/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.UsagesClient;
import com.azure.resourcemanager.sql.fluent.models.UsageInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.UsageListResult;
import reactor.core.publisher.Mono;

public final class UsagesClientImpl
implements UsagesClient {
    private final ClientLogger logger = new ClientLogger(UsagesClientImpl.class);
    private final UsagesService service;
    private final SqlManagementClientImpl client;

    UsagesClientImpl(SqlManagementClientImpl client) {
        this.service = (UsagesService)RestProxy.create(UsagesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<UsageInner>> listByInstancePoolSinglePageAsync(String resourceGroupName, String instancePoolName, Boolean expandChildren) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (instancePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instancePoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        return FluxUtil.withContext(context -> this.service.listByInstancePool(this.client.getEndpoint(), resourceGroupName, instancePoolName, expandChildren, this.client.getSubscriptionId(), "2018-06-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsageListResult)res.getValue()).value(), ((UsageListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UsageInner>> listByInstancePoolSinglePageAsync(String resourceGroupName, String instancePoolName, Boolean expandChildren, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (instancePoolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instancePoolName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2018-06-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByInstancePool(this.client.getEndpoint(), resourceGroupName, instancePoolName, expandChildren, this.client.getSubscriptionId(), "2018-06-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsageListResult)res.getValue()).value(), ((UsageListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<UsageInner> listByInstancePoolAsync(String resourceGroupName, String instancePoolName, Boolean expandChildren) {
        return new PagedFlux(() -> this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName, expandChildren), nextLink -> this.listByInstancePoolNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<UsageInner> listByInstancePoolAsync(String resourceGroupName, String instancePoolName) {
        Boolean expandChildren = null;
        return new PagedFlux(() -> this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName, expandChildren), nextLink -> this.listByInstancePoolNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<UsageInner> listByInstancePoolAsync(String resourceGroupName, String instancePoolName, Boolean expandChildren, Context context) {
        return new PagedFlux(() -> this.listByInstancePoolSinglePageAsync(resourceGroupName, instancePoolName, expandChildren, context), nextLink -> this.listByInstancePoolNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<UsageInner> listByInstancePool(String resourceGroupName, String instancePoolName, Boolean expandChildren, Context context) {
        return new PagedIterable(this.listByInstancePoolAsync(resourceGroupName, instancePoolName, expandChildren, context));
    }

    @Override
    public PagedIterable<UsageInner> listByInstancePool(String resourceGroupName, String instancePoolName) {
        Boolean expandChildren = null;
        return new PagedIterable(this.listByInstancePoolAsync(resourceGroupName, instancePoolName, expandChildren));
    }

    private Mono<PagedResponse<UsageInner>> listByInstancePoolNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByInstancePoolNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsageListResult)res.getValue()).value(), ((UsageListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UsageInner>> listByInstancePoolNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByInstancePoolNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsageListResult)res.getValue()).value(), ((UsageListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientU")
    private static interface UsagesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}/usages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UsageListResult>> listByInstancePool(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="instancePoolName") String var3, @QueryParam(value="expandChildren") Boolean var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UsageListResult>> listByInstancePoolNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

