/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.BucketProxy;
import io.github.bucket4j.distributed.proxy.RecoveryStrategy;
import io.github.bucket4j.distributed.proxy.optimization.Optimization;
import java.util.function.Function;
import java.util.function.Supplier;

public interface RemoteBucketBuilder<K> {
    public RemoteBucketBuilder<K> withRecoveryStrategy(RecoveryStrategy var1);

    public RemoteBucketBuilder<K> withOptimization(Optimization var1);

    public RemoteBucketBuilder<K> withImplicitConfigurationReplacement(long var1, TokensInheritanceStrategy var3);

    public BucketProxy build(K var1, Supplier<BucketConfiguration> var2);

    public BucketProxy build(K var1, BucketConfiguration var2);

    default public <K1> RemoteBucketBuilder<K1> withMapper(final Function<? super K1, ? extends K> mapper) {
        return new RemoteBucketBuilder<K1>(){

            @Override
            public RemoteBucketBuilder<K1> withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
                RemoteBucketBuilder.this.withRecoveryStrategy(recoveryStrategy);
                return this;
            }

            @Override
            public RemoteBucketBuilder<K1> withOptimization(Optimization optimization) {
                RemoteBucketBuilder.this.withOptimization(optimization);
                return this;
            }

            @Override
            public RemoteBucketBuilder<K1> withImplicitConfigurationReplacement(long desiredConfigurationVersion, TokensInheritanceStrategy tokensInheritanceStrategy) {
                RemoteBucketBuilder.this.withImplicitConfigurationReplacement(desiredConfigurationVersion, tokensInheritanceStrategy);
                return this;
            }

            @Override
            public BucketProxy build(K1 key, Supplier<BucketConfiguration> configurationSupplier) {
                return RemoteBucketBuilder.this.build(mapper.apply(key), configurationSupplier);
            }

            @Override
            public BucketProxy build(K1 key, BucketConfiguration configuration) {
                return RemoteBucketBuilder.this.build(mapper.apply(key), configuration);
            }

            @Override
            public <K2> RemoteBucketBuilder<K2> withMapper(Function<? super K2, ? extends K1> innerMapper) {
                return RemoteBucketBuilder.this.withMapper(mapper.compose(innerMapper));
            }
        };
    }
}

