/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.scm.maven.AbstractMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractProjectMojo
extends AbstractMojo {
    @Override
    public final void execute(MojoExecutionContext mojoExecutionContext, Set<MavenProject> executedModules) throws MojoExecutionException, MojoFailureException {
        if (executedModules.isEmpty()) {
            this.getLog().debug((CharSequence)"No modules have been executed so far, considering this module the first one within the project.");
            this.beforeProject(mojoExecutionContext);
        }
        Map<MavenProject, List<MavenProject>> projects = mojoExecutionContext.getProjects();
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        List<MavenProject> projectModules = projects.get(rootModule);
        MavenProject currentModule = mojoExecutionContext.getCurrentModule();
        Set<MavenProject> remainingModules = this.getRemainingModules(mojoExecutionContext, projectModules);
        remainingModules.removeAll(executedModules);
        remainingModules.remove(currentModule);
        if (remainingModules.isEmpty()) {
            this.getLog().debug((CharSequence)"Did not find any subsequent module with a plugin configuration, considering this module the last one within the project.");
            this.afterProject(mojoExecutionContext);
        }
    }

    private Set<MavenProject> getRemainingModules(MojoExecutionContext mojoExecutionContext, List<MavenProject> projectModules) {
        HashSet<MavenProject> remainingModules = new HashSet<MavenProject>();
        MojoExecution mojoExecution = mojoExecutionContext.getMojoExecution();
        if (mojoExecution.getPlugin().getExecutions().isEmpty()) {
            this.getLog().debug((CharSequence)"No configured executions found, assuming CLI invocation.");
            remainingModules.addAll(projectModules);
        } else {
            for (MavenProject projectModule : projectModules) {
                if (!mojoExecutionContext.containsBuildPlugin(projectModule, mojoExecution.getPlugin())) continue;
                remainingModules.add(projectModule);
            }
        }
        return remainingModules;
    }

    protected abstract void beforeProject(MojoExecutionContext var1) throws MojoExecutionException, MojoFailureException;

    protected abstract void afterProject(MojoExecutionContext var1) throws MojoExecutionException, MojoFailureException;
}

