/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.maven;

import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import com.buschmais.jqassistant.neo4j.embedded.EmbeddedNeo4jServer;
import com.buschmais.jqassistant.scm.maven.AbstractProjectMojo;
import com.buschmais.jqassistant.scm.maven.MojoExecutionContext;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="server", threadSafe=true)
public class ServerMojo
extends AbstractProjectMojo {
    @Override
    protected boolean isConnectorRequired() {
        return true;
    }

    @Override
    protected void beforeProject(MojoExecutionContext mojoExecutionContext) {
    }

    @Override
    protected void afterProject(MojoExecutionContext mojoExecutionContext) throws MojoExecutionException, MojoFailureException {
        this.withStore(store -> this.server(mojoExecutionContext, (EmbeddedGraphStore)store), mojoExecutionContext);
    }

    private void server(MojoExecutionContext mojoExecutionContext, EmbeddedGraphStore store) throws MojoExecutionException {
        MavenProject rootModule = mojoExecutionContext.getRootModule();
        this.getLog().info((CharSequence)("Running server for module " + rootModule.getGroupId() + ":" + rootModule.getArtifactId() + ":" + rootModule.getVersion()));
        EmbeddedGraphStore embeddedGraphStore = store;
        EmbeddedNeo4jServer server = embeddedGraphStore.getEmbeddedNeo4jServer();
        server.start();
        if (mojoExecutionContext.getConfiguration().server().openBrowser()) {
            server.openBrowser();
        }
        if (!mojoExecutionContext.getConfiguration().server().daemon()) {
            this.getLog().info((CharSequence)"Press <Enter> to finish.");
            try {
                System.in.read();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot read from System.in.", (Exception)e);
            }
            finally {
                server.stop();
            }
        }
    }
}

