/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.report;

import com.buschmais.jqassistant.core.report.api.model.source.FileLocation;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.report.FileSourceHelper;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PackageDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import java.util.Optional;
import lombok.Generated;

public class TypeSourceHelper {
    static String getSourceFile(TypeDescriptor typeDescriptor) {
        return typeDescriptor instanceof ClassFileDescriptor ? ((ClassFileDescriptor)typeDescriptor).getFileName() : null;
    }

    static Optional<FileLocation> getSourceLocation(TypeDescriptor typeDescriptor) {
        return TypeSourceHelper.getSourceLocation(typeDescriptor, Optional.empty(), Optional.empty());
    }

    static Optional<FileLocation> getSourceLocation(TypeDescriptor typeDescriptor, Integer lineNumber) {
        return TypeSourceHelper.getSourceLocation(typeDescriptor, Optional.ofNullable(lineNumber), Optional.ofNullable(lineNumber));
    }

    static Optional<FileLocation> getSourceLocation(TypeDescriptor typeDescriptor, Optional<Integer> startLine, Optional<Integer> endLine) {
        if (typeDescriptor instanceof ClassFileDescriptor) {
            ClassFileDescriptor classFileDescriptor = (ClassFileDescriptor)typeDescriptor;
            for (FileDescriptor parent : classFileDescriptor.getParents()) {
                if (!(parent instanceof PackageDescriptor)) continue;
                PackageDescriptor packageDescriptor = (PackageDescriptor)parent;
                FileLocation.FileLocationBuilder fileLocationBuilder = FileLocation.builder();
                fileLocationBuilder.parent(FileSourceHelper.getParentLocation((FileDescriptor)classFileDescriptor));
                fileLocationBuilder.fileName(packageDescriptor.getFileName() + "/" + classFileDescriptor.getSourceFileName());
                fileLocationBuilder.startLine(startLine);
                fileLocationBuilder.endLine(endLine);
                return Optional.of(fileLocationBuilder.build());
            }
        }
        return Optional.empty();
    }

    @Generated
    private TypeSourceHelper() {
    }
}

