/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.java.api.model.CatchesDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ThrowableDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class MethodCatchesVisitor
extends MethodVisitor {
    private final MethodDescriptor methodDescriptor;
    private final VisitorHelper visitorHelper;
    private List<TryCatchBlock> tryCatchBlocks = new ArrayList<TryCatchBlock>();
    private Map<Label, Integer> lineNumbers = new HashMap<Label, Integer>();

    public MethodCatchesVisitor(MethodDescriptor methodDescriptor, VisitorHelper visitorHelper) {
        super(589824);
        this.methodDescriptor = methodDescriptor;
        this.visitorHelper = visitorHelper;
    }

    public void visitLineNumber(int line, Label start) {
        this.lineNumbers.put(start, line);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            this.tryCatchBlocks.add(new TryCatchBlock(type, start, end, handler));
        }
    }

    public void visitEnd() {
        for (TryCatchBlock tryCatchBlock : this.tryCatchBlocks) {
            String throwableType = SignatureHelper.getObjectType(tryCatchBlock.getType());
            Object typeDescriptor = this.visitorHelper.resolveType(throwableType).getTypeDescriptor();
            this.visitorHelper.getStore().addDescriptorType(typeDescriptor, ThrowableDescriptor.class);
            CatchesDescriptor catchesDescriptor = (CatchesDescriptor)this.visitorHelper.getStore().create((Descriptor)this.methodDescriptor, CatchesDescriptor.class, typeDescriptor);
            catchesDescriptor.setFirstLineNumber(this.lineNumbers.get(tryCatchBlock.getStart()));
            catchesDescriptor.setLastLineNumber(this.lineNumbers.get(tryCatchBlock.getEnd()));
        }
    }

    private static final class TryCatchBlock {
        private final String type;
        private final Label start;
        private final Label end;
        private final Label handler;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Label getStart() {
            return this.start;
        }

        @Generated
        public Label getEnd() {
            return this.end;
        }

        @Generated
        public Label getHandler() {
            return this.handler;
        }

        @Generated
        public TryCatchBlock(String type, Label start, Label end, Label handler) {
            this.type = type;
            this.start = start;
            this.end = end;
            this.handler = handler;
        }

        @Generated
        public String toString() {
            return "MethodCatchesVisitor.TryCatchBlock(type=" + this.getType() + ", start=" + String.valueOf(this.getStart()) + ", end=" + String.valueOf(this.getEnd()) + ", handler=" + String.valueOf(this.getHandler()) + ")";
        }
    }
}

