/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AccessModifierDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ExportedPackageDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ModuleDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.OpenPackageDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PackageDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PackageToModuleDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ProvidedServiceDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.RequiresDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;

public class ModuleVisitor
extends org.objectweb.asm.ModuleVisitor {
    private final ModuleDescriptor moduleDescriptor;
    private final VisitorHelper visitorHelper;

    public ModuleVisitor(ModuleDescriptor moduleDescriptor, VisitorHelper visitorHelper) {
        super(589824);
        this.moduleDescriptor = moduleDescriptor;
        this.visitorHelper = visitorHelper;
    }

    public void visitMainClass(String mainClass) {
        Object mainClassType = this.visitorHelper.resolveType(mainClass).getTypeDescriptor();
        this.moduleDescriptor.setMainClass((TypeDescriptor)mainClassType);
    }

    public void visitRequire(String module, int access, String version) {
        ModuleDescriptor requiredModule = this.resolveModule(module, version);
        RequiresDescriptor requiresDescriptor = (RequiresDescriptor)this.visitorHelper.getStore().create((Descriptor)this.moduleDescriptor, RequiresDescriptor.class, (Descriptor)requiredModule);
        this.applyFlags(requiresDescriptor, access);
    }

    public void visitExport(String packaze, int access, String ... modules) {
        ExportedPackageDescriptor exportedPackage = this.packageToModule(packaze, access, modules, ExportedPackageDescriptor.class);
        this.moduleDescriptor.getExportedPackages().add(exportedPackage);
    }

    public void visitOpen(String packaze, int access, String ... modules) {
        OpenPackageDescriptor openPackage = this.packageToModule(packaze, access, modules, OpenPackageDescriptor.class);
        this.moduleDescriptor.getOpenPackages().add(openPackage);
    }

    public void visitUse(String service) {
        Object serviceType = this.visitorHelper.resolveType(SignatureHelper.getObjectType(service)).getTypeDescriptor();
        this.moduleDescriptor.getUsesServices().add((TypeDescriptor)serviceType);
    }

    public void visitProvide(String service, String ... providers) {
        ProvidedServiceDescriptor providesService = (ProvidedServiceDescriptor)this.visitorHelper.getStore().create(ProvidedServiceDescriptor.class);
        providesService.setService((TypeDescriptor)this.visitorHelper.resolveType(SignatureHelper.getObjectType(service)).getTypeDescriptor());
        for (String provider : providers) {
            providesService.getProviders().add((TypeDescriptor)this.visitorHelper.resolveType(SignatureHelper.getObjectType(provider)).getTypeDescriptor());
        }
        this.moduleDescriptor.getProvidesServices().add(providesService);
    }

    private ModuleDescriptor resolveModule(String module, String version) {
        ScannerContext scannerContext = this.visitorHelper.getScannerContext();
        return ((TypeResolver)scannerContext.peek(TypeResolver.class)).requireModule(module, version, scannerContext);
    }

    private <D extends PackageToModuleDescriptor> D packageToModule(String packaze, int access, String[] modules, Class<D> descriptorType) {
        PackageToModuleDescriptor descriptor = (PackageToModuleDescriptor)this.visitorHelper.getStore().create(descriptorType);
        this.applyFlags(descriptor, access);
        descriptor.setPackage(this.resolvePackage(packaze));
        this.addToModules(descriptor, modules);
        return (D)descriptor;
    }

    private void addToModules(PackageToModuleDescriptor packageToModuleDescriptor, String[] modules) {
        if (modules != null) {
            for (String module : modules) {
                ModuleDescriptor toModule = this.resolveModule(module, null);
                packageToModuleDescriptor.getToModules().add(toModule);
            }
        }
    }

    private PackageDescriptor resolvePackage(String packaze) {
        ScannerContext scannerContext = this.visitorHelper.getScannerContext();
        return ((TypeResolver)scannerContext.peek(TypeResolver.class)).require("/" + packaze, PackageDescriptor.class, scannerContext);
    }

    private void applyFlags(AccessModifierDescriptor accessModifierDescriptor, int access) {
        if (this.visitorHelper.hasFlag(access, 64)) {
            accessModifierDescriptor.setStatic(Boolean.TRUE);
        }
        if (this.visitorHelper.hasFlag(access, 32)) {
            accessModifierDescriptor.setTransitive(Boolean.TRUE);
        }
        if (this.visitorHelper.hasFlag(access, 4096)) {
            accessModifierDescriptor.setSynthetic(Boolean.TRUE);
        }
        if (this.visitorHelper.hasFlag(access, 32768)) {
            accessModifierDescriptor.setMandated(Boolean.TRUE);
        }
    }
}

