/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.api.artifact;

import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class MavenArtifactHelper {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");

    private MavenArtifactHelper() {
    }

    public static void setCoordinates(MavenArtifactDescriptor artifactDescriptor, Coordinates coordinates) {
        artifactDescriptor.setFullQualifiedName(MavenArtifactHelper.getId(coordinates));
        artifactDescriptor.setGroup(coordinates.getGroup());
        artifactDescriptor.setName(coordinates.getName());
        artifactDescriptor.setVersion(coordinates.getVersion());
        artifactDescriptor.setClassifier(coordinates.getClassifier());
        artifactDescriptor.setType(coordinates.getType());
    }

    public static String getId(Coordinates coordinates) {
        String version;
        StringBuilder id = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)coordinates.getGroup())) {
            id.append(coordinates.getGroup());
        }
        id.append(':');
        id.append(coordinates.getName());
        id.append(':');
        id.append(coordinates.getType());
        String classifier = coordinates.getClassifier();
        if (StringUtils.isNotEmpty((CharSequence)classifier)) {
            id.append(':');
            id.append(classifier);
        }
        if (StringUtils.isNotEmpty((CharSequence)(version = coordinates.getVersion()))) {
            id.append(':');
            id.append(version);
        }
        return id.toString();
    }

    public static boolean isSnapshot(Coordinates coordinates) {
        String version = coordinates.getVersion();
        return version.endsWith(SNAPSHOT) || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }

    public static String getBaseVersion(Coordinates coordinates) {
        String version = coordinates.getVersion();
        Matcher m = SNAPSHOT_TIMESTAMP.matcher(version);
        if (m.matches()) {
            if (m.group(1) != null) {
                return m.group(1) + SNAPSHOT;
            }
            return SNAPSHOT;
        }
        return version;
    }
}

