/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing;

import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AbstractBaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AliasKeyNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AliasNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AnchorCache;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.BaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.ComplexKeyNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.DocumentNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.KeyNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.MapNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.ParserContext;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.ParsingContextType;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.ScalarNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.SequenceNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.SimpleKeyNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.StreamNode;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.snakeyaml.engine.v2.events.AliasEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.Event;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.NodeEvent;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.events.StreamStartEvent;

public class EventParser {
    private int tokenIndexSource = 0;
    private ParserContext parserContext = new ParserContext();
    private AnchorCache anchorCache = new AnchorCache();

    int getNextTokenIndex() {
        return this.tokenIndexSource++;
    }

    public StreamNode parse(Stream<Event> events) {
        Consumer<Event> consumer = event -> {
            switch (event.getEventId()) {
                case Alias: {
                    boolean referencedNodeIsValueForKey = this.parserContext.isInKey();
                    this.handleAlias((AliasEvent)event);
                    if (!referencedNodeIsValueForKey) break;
                    this.getParserContext().leave();
                    break;
                }
                case Scalar: {
                    boolean scalarIsValueForKey = this.parserContext.isInKey();
                    this.handleScalar((ScalarEvent)event);
                    if (!scalarIsValueForKey) break;
                    this.parserContext.leave();
                    break;
                }
                case StreamStart: {
                    this.handleStreamStart((StreamStartEvent)event);
                    break;
                }
                case DocumentStart: {
                    this.handleDocumentStart((DocumentStartEvent)event);
                    break;
                }
                case SequenceStart: {
                    boolean seqIsValueForKey = this.parserContext.isInKey();
                    this.handleSequenceStart((SequenceStartEvent)event);
                    this.parserContext.getCurrent().setKeyForValue(seqIsValueForKey);
                    break;
                }
                case MappingStart: {
                    boolean mapIsValueForKey = this.parserContext.isInKey();
                    this.handleMapStart((MappingStartEvent)event);
                    this.parserContext.getCurrent().setKeyForValue(mapIsValueForKey);
                    break;
                }
                case MappingEnd: 
                case SequenceEnd: 
                case DocumentEnd: 
                case StreamEnd: {
                    boolean wasValueForKey = this.parserContext.getCurrent().isKeyForValue();
                    this.parserContext.leave();
                    if (!wasValueForKey) break;
                    this.parserContext.leave();
                    break;
                }
                default: {
                    this.abortProcessing(this.parserContext.getCurrent(), (Event)event);
                }
            }
        };
        events.forEachOrdered(consumer);
        return this.parserContext.getRootNode();
    }

    protected ParserContext getParserContext() {
        return this.parserContext;
    }

    protected AnchorCache getAnchorCache() {
        return this.anchorCache;
    }

    private void abortProcessing(ParsingContextType<AbstractBaseNode> context, Event event) {
        ParsingContextType.Type type = context.getType();
        Event.ID eventId = event.getEventId();
        String message = String.format("Unable to process event '%s' while current parsing context is '%s'", new Object[]{type, eventId});
        throw new IllegalStateException(message);
    }

    private void handleAlias(AliasEvent event) {
        String aliasName = event.getAlias().getValue();
        AliasNode aliasNode = new AliasNode(event, this.getNextTokenIndex());
        this.anchorCache.getAnchor(aliasName).ifPresent(aliasNode::setAliasedNode);
        if (this.parserContext.isInSequence()) {
            ParsingContextType context = this.parserContext.getCurrent();
            int index = context.getPositionalContext().inc();
            aliasNode.setIndex(index);
            SequenceNode sequenceNode = (SequenceNode)context.getNode();
            sequenceNode.addAlias(aliasNode);
        } else if (this.parserContext.isInKey()) {
            ParsingContextType context = this.parserContext.getCurrent();
            KeyNode keyNode = (KeyNode)context.getNode();
            keyNode.setValue(aliasNode);
        } else if (this.parserContext.isInMap()) {
            BaseNode referencedNode = (BaseNode)this.anchorCache.getAnchor(aliasName).map(node -> {
                if (node instanceof SimpleKeyNode) {
                    return ((SimpleKeyNode)node).getKey();
                }
                return node;
            }).get();
            AliasKeyNode keyNode = new AliasKeyNode(event, this.getNextTokenIndex(), referencedNode);
            ParsingContextType context = this.parserContext.getCurrent();
            MapNode mapNode = (MapNode)context.getNode();
            mapNode.addKey(keyNode);
            ParsingContextType<AliasKeyNode> inAliasKey = ParsingContextType.ofInAliasKey(keyNode);
            this.parserContext.enter(inAliasKey);
        } else {
            this.abortProcessing(this.parserContext.getCurrent(), (Event)event);
        }
    }

    private void handleMapStart(MappingStartEvent event) {
        MapNode mapNode = new MapNode(event, this.getNextTokenIndex());
        ParsingContextType contextType = this.parserContext.getCurrent();
        ParsingContextType<MapNode> inMap = ParsingContextType.ofInMap(mapNode);
        this.checkAndHandleAnchor(mapNode);
        if (this.parserContext.isInDocument()) {
            DocumentNode documentNode = (DocumentNode)contextType.getNode();
            documentNode.addMap(mapNode);
        } else if (this.parserContext.isInSequence()) {
            int index = contextType.getPositionalContext().inc();
            SequenceNode sequenceNode = (SequenceNode)this.parserContext.getCurrent().getNode();
            mapNode.setIndex(index);
            sequenceNode.addMap(mapNode);
        } else if (this.parserContext.isInKey()) {
            KeyNode keyNode = (KeyNode)this.parserContext.getCurrent().getNode();
            keyNode.setValue(mapNode);
        } else if (this.parserContext.isInMap()) {
            ComplexKeyNode complexKey = new ComplexKeyNode((NodeEvent)event, this.getNextTokenIndex());
            complexKey.setKeyNode(mapNode);
            ParsingContextType<ComplexKeyNode> inComplexKey = ParsingContextType.ofInComplexKey(complexKey);
            MapNode parentMapNode = (MapNode)this.parserContext.getCurrent().getNode();
            parentMapNode.addKey(complexKey);
            this.parserContext.enter(inComplexKey);
        } else {
            this.abortProcessing(this.parserContext.getCurrent(), (Event)event);
        }
        this.parserContext.enter(inMap);
    }

    private void handleSequenceStart(SequenceStartEvent event) {
        SequenceNode sequenceNode = new SequenceNode(event, this.getNextTokenIndex());
        ParsingContextType<SequenceNode> inSequence = ParsingContextType.ofInSequence(sequenceNode);
        this.checkAndHandleAnchor(sequenceNode);
        if (this.parserContext.isInDocument()) {
            ((DocumentNode)this.parserContext.getCurrent().getNode()).addSequence(sequenceNode);
        } else if (this.parserContext.isInSequence()) {
            int index = this.parserContext.getCurrent().getPositionalContext().inc();
            sequenceNode.setIndex(index);
            SequenceNode parentSeqNode = (SequenceNode)this.parserContext.getCurrent().getNode();
            parentSeqNode.addSequence(sequenceNode);
        } else if (this.parserContext.isInMap()) {
            ComplexKeyNode complexKey = new ComplexKeyNode((NodeEvent)event, this.getNextTokenIndex());
            complexKey.setKeyNode(sequenceNode);
            ParsingContextType<ComplexKeyNode> inComplexKey = ParsingContextType.ofInComplexKey(complexKey);
            MapNode mapNode = (MapNode)this.parserContext.getCurrent().getNode();
            mapNode.addKey(complexKey);
            this.parserContext.enter(inComplexKey);
        } else if (this.parserContext.isInKey()) {
            KeyNode keyNode = (KeyNode)this.parserContext.getCurrent().getNode();
            keyNode.setValue(sequenceNode);
        } else {
            this.abortProcessing(this.parserContext.getCurrent(), (Event)event);
        }
        this.parserContext.enter(inSequence);
    }

    private void handleScalar(ScalarEvent event) {
        ParsingContextType contextType = this.parserContext.getCurrent();
        if (this.parserContext.isInSequence()) {
            int index = contextType.getPositionalContext().inc();
            SequenceNode sequenceNode = (SequenceNode)contextType.getNode();
            ScalarNode scalarNode = new ScalarNode(event, this.getNextTokenIndex());
            scalarNode.setIndex(index);
            sequenceNode.addScalar(scalarNode);
            this.checkAndHandleAnchor(scalarNode);
        } else if (this.parserContext.isInMap()) {
            MapNode mapNode = (MapNode)contextType.getNode();
            ScalarNode scalarNode = new ScalarNode(event, this.getNextTokenIndex());
            SimpleKeyNode keyNode = new SimpleKeyNode(scalarNode, this.getNextTokenIndex());
            this.checkAndHandleAnchor(keyNode);
            ParsingContextType<SimpleKeyNode> newContextType = ParsingContextType.ofInKey(keyNode);
            this.parserContext.enter(newContextType);
            mapNode.addKey(keyNode);
        } else if (this.parserContext.isInKey()) {
            ScalarNode scalarNode = new ScalarNode(event, this.getNextTokenIndex());
            KeyNode keyNode = (KeyNode)contextType.getNode();
            keyNode.setValue(scalarNode);
            this.checkAndHandleAnchor(scalarNode);
        } else if (this.parserContext.isInDocument()) {
            DocumentNode documentNode = (DocumentNode)contextType.getNode();
            ScalarNode scalarNode = new ScalarNode(event, this.getNextTokenIndex());
            documentNode.addScalar(scalarNode);
            this.checkAndHandleAnchor(scalarNode);
        } else {
            this.abortProcessing(this.parserContext.getCurrent(), (Event)event);
        }
    }

    private void checkAndHandleAnchor(BaseNode<?> node) {
        node.getEvent().getAnchor().ifPresent(anchor -> this.anchorCache.addAnchor(node));
    }

    private void handleDocumentStart(DocumentStartEvent event) {
        if (this.parserContext.isNotInStream()) {
            this.abortProcessing(this.parserContext.getCurrent(), (Event)event);
        }
        DocumentNode documentNode = new DocumentNode(event, this.getNextTokenIndex());
        ParsingContextType<DocumentNode> inDocument = ParsingContextType.ofInDocument(documentNode);
        this.parserContext.enter(inDocument);
        ParsingContextType streamContext = this.parserContext.getParent();
        StreamNode streamNode = (StreamNode)streamContext.getNode();
        streamNode.addDocument(documentNode);
    }

    private void handleStreamStart(StreamStartEvent event) {
        StreamNode node = new StreamNode(event, this.getNextTokenIndex());
        ParsingContextType<StreamNode> inStream = ParsingContextType.ofInStream(node);
        this.parserContext.setRootNode(node);
        this.parserContext.enter(inStream);
    }

    public boolean hasAnchor(String anchor) {
        return this.anchorCache.hasAnchor(anchor);
    }

    public Optional<BaseNode<? extends NodeEvent>> getAnchor(String anchor) {
        return this.anchorCache.getAnchor(anchor);
    }
}

