package com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.model;

import com.cebpubservice.remotebidevaluation.CommonRequest;
import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.constant.ComponentExpertLibraryShareExtractConstant;
import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.param.PreQueryExpertParamDTO;
import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.param.QueryExtractMajorParamDTO;
import com.cebpubservice.remotebidevaluation.utils.CebsConstant;

/**
 * 专家预查询
 *
 * @author 柏晨瑶
 * ===============================
 * Date：2025/02/20
 * Time：20:39
 * ================================
 */
public class PreQueryExpertRequest extends CommonRequest<PreQueryExpertParamDTO> {

    public PreQueryExpertRequest(PreQueryExpertParamDTO dto) {
        // 设置请求的基础URL
        super(ComponentExpertLibraryShareExtractConstant.API_PATH);
        // 设置请求的头部参数，用于业务编码
        this.putHeadParameter(CebsConstant.SERVICE_CODE, ComponentExpertLibraryShareExtractConstant.EXPERT_LIBRARY_SHARE_EXTRACT_SERVICE_NAME);
        // 设置请求的头部参数，用于功能编码
        this.putHeadParameter(CebsConstant.FEATURE_CODE, ComponentExpertLibraryShareExtractConstant.FEATURE_CODE_PQE);
        // 设置请求的头部参数，用于标识版本号
        this.putHeadParameter(CebsConstant.VERSION_CODE, ComponentExpertLibraryShareExtractConstant.V_1_0_0);

        // 设置请求的数据部分，即查询参数DTO对象
        this.data = dto;
    }

}
