package com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.model;

import com.cebpubservice.remotebidevaluation.CommonRequest;
import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.constant.ComponentExpertLibraryShareExtractConstant;
import com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.param.PushExpertExtractApplyParamDTO;
import com.cebpubservice.remotebidevaluation.utils.CebsConstant;

/**
 * 推送专家抽取申请信息请求参数
 * @author 柏晨瑶
 * ===============================
 * Date：2025/1/14
 * Time：18:03
 * ================================
 */
public class PushExpertExtractApplyRequest extends CommonRequest<PushExpertExtractApplyParamDTO> {

    /**
     * 构造专家抽取结果的类。
     *
     * 该构造函数用于推送专家抽取结果请求参数。
     * 通过设置请求头部参数，包括服务代码、功能代码、应用代码和版本号，
     * 以及传入的参数对象，为调用推送专家抽取结果接口做准备。
     * @param dto 推送专家抽取结果参数数据对象，包含具体地请求数据。
     */
    public PushExpertExtractApplyRequest(PushExpertExtractApplyParamDTO dto) {
        // 设置请求的基础URL
        super(ComponentExpertLibraryShareExtractConstant.API_PATH);
        // 设置请求的头部参数，用于业务编码
        this.putHeadParameter(CebsConstant.SERVICE_CODE, ComponentExpertLibraryShareExtractConstant.EXPERT_LIBRARY_SHARE_EXTRACT_SERVICE_NAME);
        // 设置请求的头部参数，用于功能编码
        this.putHeadParameter(CebsConstant.FEATURE_CODE, ComponentExpertLibraryShareExtractConstant.FEATURE_CODE_PEEA);
        // 设置请求的头部参数，用于标识版本号
        this.putHeadParameter(CebsConstant.VERSION_CODE, ComponentExpertLibraryShareExtractConstant.V_1_0_0);

        // 设置请求的数据部分，即查询参数DTO对象
        this.data = dto;
    }
}
