package com.cebpubservice.remotebidevaluation.component.sdk.expertlibraryshareextract.param;

import java.util.Date;
import java.util.List;

/**
 * 推送专家抽取申请信息
 * @author 柏晨瑶
 * ===============================
 * Date：2025/1/14
 * Time：18:09
 * ================================
 */
public class PushExpertExtractApplyParamDTO {

    /**
     * 远程异地评标编号(UUID，由远程异地项目登记工具生成，专家抽取、场所工位预约共用)
     */
    private String remoteBidEvaluationId;

    /**
     * 专家抽取申请编号
     */
    private String expertExtractApplyId;

    /**
     * 专家抽取编号
     */
    private String expertExtractId;

    /**
     * 电子交易系统编码
     */
    private String tradingSystemCode;

    /**
     * 主场交易中心场所编码
     */
    private String homeSiteTradingCenterCode;

    /**
     * 评标专家库标识码
     */
    private String expertLibraryCode;

    /**
     * 主副场专家库标识（1：主场；2副场）
     */
    private String homeDeputyExpertLibraryType;

    /**
     * 招标项目编号
     */
    private String tenderProjectCode;

    /**
     * 招标项目名称
     */
    private String tenderProjectName;

    /**
     * 标段信息列表
     */
    private List<BidSectionParamDTO> bidSectionList;

    /**
     * 项目评标模式：
     * 远程异地省内评标(REMOTE_EVALUATION_INSIDE_PROVINCE)、远程异地省外评标(REMOTE_EVALUATION_OUTSIDE_PROVINCE)
     */
    private String projectEvaluationMode;

    /**
     * 专家用途类型（1：评标评审；2：项目论证；3：资格预审；9：其他）
     */
    private String serverType;

    /**
     * 抽取专业编码
     */
    private String majorCategoryCode;

    /**
     * 抽取专业小类编码（参考数据规范4.4.2 建设工程项目专业分类编码，子级编码，可设置多个专业小类，多个专业小类之间逗号,隔开）
     */
    private String majorSubcategoryCode;

    /**
     * 抽取人数
     */
    private Integer expertNum;

    /**
     * 预计评标开始时间
     */
    private Date estimateEvaluationStartTime;

    /**
     * 预计评标结束时间
     */
    private Date estimateEvaluationEndTime;

    /**
     * 回避单位列表
     */
    private List<AvoidOrgParamDTO> avoidOrgList;

    /**
     * 工位列表
     */
    private List<SeatParamDTO> seatList;

    public String getRemoteBidEvaluationId() {
        return remoteBidEvaluationId;
    }

    public void setRemoteBidEvaluationId(String remoteBidEvaluationId) {
        this.remoteBidEvaluationId = remoteBidEvaluationId;
    }

    public String getExpertExtractApplyId() {
        return expertExtractApplyId;
    }

    public void setExpertExtractApplyId(String expertExtractApplyId) {
        this.expertExtractApplyId = expertExtractApplyId;
    }

    public String getExpertExtractId() {
        return expertExtractId;
    }

    public void setExpertExtractId(String expertExtractId) {
        this.expertExtractId = expertExtractId;
    }

    public String getTradingSystemCode() {
        return tradingSystemCode;
    }

    public void setTradingSystemCode(String tradingSystemCode) {
        this.tradingSystemCode = tradingSystemCode;
    }

    public String getExpertLibraryCode() {
        return expertLibraryCode;
    }

    public void setExpertLibraryCode(String expertLibraryCode) {
        this.expertLibraryCode = expertLibraryCode;
    }

    public String getHomeDeputyExpertLibraryType() {
        return homeDeputyExpertLibraryType;
    }

    public void setHomeDeputyExpertLibraryType(String homeDeputyExpertLibraryType) {
        this.homeDeputyExpertLibraryType = homeDeputyExpertLibraryType;
    }

    public String getTenderProjectCode() {
        return tenderProjectCode;
    }

    public void setTenderProjectCode(String tenderProjectCode) {
        this.tenderProjectCode = tenderProjectCode;
    }

    public String getTenderProjectName() {
        return tenderProjectName;
    }

    public void setTenderProjectName(String tenderProjectName) {
        this.tenderProjectName = tenderProjectName;
    }

    public List<BidSectionParamDTO> getBidSectionList() {
        return bidSectionList;
    }

    public void setBidSectionList(List<BidSectionParamDTO> bidSectionList) {
        this.bidSectionList = bidSectionList;
    }

    public String getProjectEvaluationMode() {
        return projectEvaluationMode;
    }

    public void setProjectEvaluationMode(String projectEvaluationMode) {
        this.projectEvaluationMode = projectEvaluationMode;
    }

    public String getServerType() {
        return serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getHomeSiteTradingCenterCode() {
        return homeSiteTradingCenterCode;
    }

    public void setHomeSiteTradingCenterCode(String homeSiteTradingCenterCode) {
        this.homeSiteTradingCenterCode = homeSiteTradingCenterCode;
    }

    public String getMajorCategoryCode() {
        return majorCategoryCode;
    }

    public void setMajorCategoryCode(String majorCategoryCode) {
        this.majorCategoryCode = majorCategoryCode;
    }

    public String getMajorSubcategoryCode() {
        return majorSubcategoryCode;
    }

    public void setMajorSubcategoryCode(String majorSubcategoryCode) {
        this.majorSubcategoryCode = majorSubcategoryCode;
    }

    public Integer getExpertNum() {
        return expertNum;
    }

    public void setExpertNum(Integer expertNum) {
        this.expertNum = expertNum;
    }

    public Date getEstimateEvaluationStartTime() {
        return estimateEvaluationStartTime;
    }

    public void setEstimateEvaluationStartTime(Date estimateEvaluationStartTime) {
        this.estimateEvaluationStartTime = estimateEvaluationStartTime;
    }

    public Date getEstimateEvaluationEndTime() {
        return estimateEvaluationEndTime;
    }

    public void setEstimateEvaluationEndTime(Date estimateEvaluationEndTime) {
        this.estimateEvaluationEndTime = estimateEvaluationEndTime;
    }

    public List<AvoidOrgParamDTO> getAvoidOrgList() {
        return avoidOrgList;
    }

    public void setAvoidOrgList(List<AvoidOrgParamDTO> avoidOrgList) {
        this.avoidOrgList = avoidOrgList;
    }

    public List<SeatParamDTO> getSeatList() {
        return seatList;
    }

    public void setSeatList(List<SeatParamDTO> seatList) {
        this.seatList = seatList;
    }
}
