/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.channel;

import com.cloudhopper.smpp.channel.ChannelUtil;
import com.cloudhopper.smpp.channel.SmppSessionPduDecoder;
import com.cloudhopper.smpp.channel.SmppSessionThreadRenamer;
import com.cloudhopper.smpp.channel.SmppSessionWrapper;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.impl.UnboundSmppSession;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelPipelineCoverage(value="all")
public class SmppServerConnector
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(SmppServerConnector.class);
    private ChannelGroup channels;
    private DefaultSmppServer server;

    public SmppServerConnector(ChannelGroup channels, DefaultSmppServer server) {
        this.channels = channels;
        this.server = server;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        this.channels.add((Object)channel);
        this.server.getCounters().incrementChannelConnectsAndGet();
        String channelName = ChannelUtil.createChannelName(channel);
        String threadName = this.server.getConfiguration().getName() + ".UnboundSession." + channelName;
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.server.getConfiguration().getName());
        logger.info("New channel from [{}]", (Object)channelName);
        Thread.currentThread().setName(currentThreadName);
        channel.getPipeline().addLast("smppSessionThreadRenamer", (ChannelHandler)new SmppSessionThreadRenamer(threadName));
        channel.getPipeline().addLast("smppSessionPduDecoder", (ChannelHandler)new SmppSessionPduDecoder(this.server.getTranscoder()));
        UnboundSmppSession session = new UnboundSmppSession(channelName, channel, this.server);
        channel.getPipeline().addLast("smppSessionWrapper", (ChannelHandler)new SmppSessionWrapper(session));
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channels.remove((Object)e.getChannel());
        this.server.getCounters().incrementChannelDisconnectsAndGet();
    }
}

