/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.util;

import com.cloudhopper.commons.util.HexUtil;

public class SmppUtil {
    public static boolean isMessageTypeAnyDeliveryReceipt(byte esmClass) {
        return (esmClass & 0x1C) > 0;
    }

    public static boolean isMessageTypeManualUserAcknowledgement(byte esmClass) {
        return (esmClass & 0x1C) == 16;
    }

    public static boolean isMessageTypeEsmeDeliveryReceipt(byte esmClass) {
        return (esmClass & 0x1C) == 8;
    }

    public static boolean isMessageTypeIntermediateDeliveryReceipt(byte esmClass) {
        return (esmClass & 0x20) == 32;
    }

    public static boolean isMessageTypeSmscDeliveryReceipt(byte esmClass) {
        return (esmClass & 0x1C) == 4;
    }

    public static boolean isUserDataHeaderIndicatorEnabled(byte esmClass) {
        return (esmClass & 0x40) == 64;
    }

    public static boolean isReplyPathEnabled(byte esmClass) {
        return (esmClass & 0xFFFFFF80) == -128;
    }

    public static boolean isSmscDeliveryReceiptRequested(byte registeredDelivery) {
        return (registeredDelivery & 3) == 1;
    }

    public static boolean isSmscDeliveryReceiptOnFailureRequested(byte registeredDelivery) {
        return (registeredDelivery & 3) == 2;
    }

    public static boolean isIntermediateReceiptRequested(byte registeredDelivery) {
        return (registeredDelivery & 0x20) == 32;
    }

    public static String toInterfaceVersionString(byte interfaceVersion) {
        String ver = HexUtil.toHexString((byte)interfaceVersion);
        if (ver == null || ver.length() != 2) {
            return ver;
        }
        return ver.substring(0, 1) + "." + ver.substring(1);
    }
}

