/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.CouchbaseThreadFactory;
import com.couchbase.client.core.util.NanoTimestamp;
import com.couchbase.connect.kafka.util.ConnectHelper;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
public final class Watchdog {
    private static final Logger log = LoggerFactory.getLogger(Watchdog.class);
    private static final ThreadFactory threadFactory = new CouchbaseThreadFactory("cb-watchdog-");
    private final String taskUuid;
    private ScheduledExecutorService executor;
    private volatile State lastObservedState = new State("stopped");
    private volatile State currentState = new State("initial");

    public Watchdog(String taskUuid) {
        this.taskUuid = Objects.requireNonNull(taskUuid);
    }

    public void enterState(String s) {
        this.currentState = new State(s);
        log.debug("Transitioned to state: {}; taskUuid={}", (Object)s, (Object)this.taskUuid);
    }

    public synchronized void start() {
        this.stop();
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        ConnectHelper.getConnectorContextFromLoggingContext().ifPresent(ctx -> this.executor.execute(() -> Thread.currentThread().setName(Thread.currentThread().getName() + ctx)));
        this.lastObservedState = this.currentState = new State("starting");
        this.executor.scheduleWithFixedDelay(() -> {
            if (this.currentState == this.lastObservedState) {
                Duration elapsed = this.lastObservedState.startTime.elapsed();
                log.warn("SourceTask has been in same state ({}) for {}; taskUuid={} ", new Object[]{this.lastObservedState.name, elapsed, this.taskUuid});
            }
            this.lastObservedState = this.currentState;
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public synchronized void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    private static class State {
        private final NanoTimestamp startTime = NanoTimestamp.now();
        private final String name;

        private State(String name) {
            this.name = Objects.requireNonNull(name);
        }
    }
}

