/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.saml;

import com.coveo.saml.SamlException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class ResponseSchemaValidator {
    public void validate(StatusResponseType response) throws SamlException {
        this.validateStatus(response);
        this.validateID(response);
        this.validateVersion(response);
        this.validateIssueInstant(response);
    }

    private void validateStatus(StatusResponseType response) throws SamlException {
        if (response.getStatus() == null) {
            throw new SamlException("Status is required");
        }
    }

    private void validateID(StatusResponseType response) throws SamlException {
        if (StringUtils.isEmpty((CharSequence)response.getID())) {
            throw new SamlException("ID attribute must not be empty");
        }
    }

    private void validateVersion(StatusResponseType response) throws SamlException {
        if (response.getVersion() == null) {
            throw new SamlException("Version attribute must not be null");
        }
        if (!Objects.equals(response.getVersion().toString(), SAMLVersion.VERSION_20.toString())) {
            throw new SamlException("Wrong SAML Version");
        }
    }

    private void validateIssueInstant(StatusResponseType response) throws SamlException {
        if (response.getIssueInstant() == null) {
            throw new SamlException("IssueInstant attribute must not be null");
        }
    }
}

