/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.EventAlertType;
import com.datadog.api.client.v1.model.EventPriority;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"alert_type", "date_happened", "device_name", "host", "id", "id_str", "payload", "priority", "source_type_name", "tags", "text", "title", "url"})
public class Event {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALERT_TYPE = "alert_type";
    private EventAlertType alertType;
    public static final String JSON_PROPERTY_DATE_HAPPENED = "date_happened";
    private Long dateHappened;
    public static final String JSON_PROPERTY_DEVICE_NAME = "device_name";
    private String deviceName;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_ID_STR = "id_str";
    private String idStr;
    public static final String JSON_PROPERTY_PAYLOAD = "payload";
    private String payload;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private JsonNullable<EventPriority> priority = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SOURCE_TYPE_NAME = "source_type_name";
    private String sourceTypeName;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TEXT = "text";
    private String text;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    private Map<String, Object> additionalProperties;

    public Event alertType(EventAlertType alertType) {
        this.alertType = alertType;
        this.unparsed |= !alertType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="alert_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventAlertType getAlertType() {
        return this.alertType;
    }

    public void setAlertType(EventAlertType alertType) {
        if (!alertType.isValid()) {
            this.unparsed = true;
        }
        this.alertType = alertType;
    }

    public Event dateHappened(Long dateHappened) {
        this.dateHappened = dateHappened;
        return this;
    }

    @Nullable
    @JsonProperty(value="date_happened")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDateHappened() {
        return this.dateHappened;
    }

    public void setDateHappened(Long dateHappened) {
        this.dateHappened = dateHappened;
    }

    public Event deviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    @Nullable
    @JsonProperty(value="device_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Event host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    @Nullable
    @JsonProperty(value="id_str")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdStr() {
        return this.idStr;
    }

    @Nullable
    @JsonProperty(value="payload")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayload() {
        return this.payload;
    }

    public Event priority(EventPriority priority) {
        this.priority = JsonNullable.of((Object)priority);
        return this;
    }

    @Nullable
    @JsonIgnore
    public EventPriority getPriority() {
        return (EventPriority)this.priority.orElse(null);
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<EventPriority> getPriority_JsonNullable() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority_JsonNullable(JsonNullable<EventPriority> priority) {
        this.priority = priority;
    }

    public void setPriority(EventPriority priority) {
        if (!priority.isValid()) {
            this.unparsed = true;
        }
        this.priority = JsonNullable.of((Object)priority);
    }

    public Event sourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
        return this;
    }

    @Nullable
    @JsonProperty(value="source_type_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public Event tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Event addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Event text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Event title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Nullable
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonAnySetter
    public Event putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.alertType, event.alertType) && Objects.equals(this.dateHappened, event.dateHappened) && Objects.equals(this.deviceName, event.deviceName) && Objects.equals(this.host, event.host) && Objects.equals(this.id, event.id) && Objects.equals(this.idStr, event.idStr) && Objects.equals(this.payload, event.payload) && Objects.equals(this.priority, event.priority) && Objects.equals(this.sourceTypeName, event.sourceTypeName) && Objects.equals(this.tags, event.tags) && Objects.equals(this.text, event.text) && Objects.equals(this.title, event.title) && Objects.equals(this.url, event.url) && Objects.equals(this.additionalProperties, event.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.alertType, this.dateHappened, this.deviceName, this.host, this.id, this.idStr, this.payload, this.priority, this.sourceTypeName, this.tags, this.text, this.title, this.url, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    alertType: ").append(this.toIndentedString(this.alertType)).append("\n");
        sb.append("    dateHappened: ").append(this.toIndentedString(this.dateHappened)).append("\n");
        sb.append("    deviceName: ").append(this.toIndentedString(this.deviceName)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    idStr: ").append(this.toIndentedString(this.idStr)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    sourceTypeName: ").append(this.toIndentedString(this.sourceTypeName)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

