/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.cpp;

import com.diffplug.spotless.ForeignExe;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ClangFormatStep {
    private final String version;
    @Nullable
    private final String pathToExe;
    @Nullable
    private final String style;

    public static String name() {
        return "clang";
    }

    public static String defaultVersion() {
        return "10.0.1";
    }

    private ClangFormatStep(String version, @Nullable String pathToExe, @Nullable String style) {
        this.version = version;
        this.pathToExe = pathToExe;
        this.style = style;
    }

    public static ClangFormatStep withVersion(String version) {
        return new ClangFormatStep(version, null, null);
    }

    public ClangFormatStep withStyle(String style) {
        return new ClangFormatStep(this.version, this.pathToExe, style);
    }

    public ClangFormatStep withPathToExe(String pathToExe) {
        return new ClangFormatStep(this.version, pathToExe, this.style);
    }

    public FormatterStep create() {
        return FormatterStep.createLazy(ClangFormatStep.name(), this::createState, State::toFunc);
    }

    private State createState() throws IOException, InterruptedException {
        String howToInstall = "You can download clang-format from https://releases.llvm.org and then point Spotless to it with `pathToExe('/path/to/clang-format')` or you can use your platform's package manager:\n  win:   choco install llvm --version {version}  (try dropping version if it fails)\n  mac:   brew install clang-format (TODO: how to specify version?)\n  linux: apt install clang-format  (try clang-format-{version} with dropped minor versions)\n    github issue to handle this better: https://github.com/diffplug/spotless/issues/673";
        String exeAbsPath = ForeignExe.nameAndVersion("clang-format", this.version).pathToExe(this.pathToExe).fixCantFind(howToInstall).fixWrongVersion("You can tell Spotless to use the version you already have with `clangFormat('{versionFound}')`or you can download the currently specified version, {version}.\n" + howToInstall).confirmVersionAndGetAbsolutePath();
        return new State(this, exeAbsPath);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class State
    implements Serializable {
        private static final long serialVersionUID = -1825662356883926318L;
        final String version;
        @Nullable
        final String style;
        final transient List<String> args;

        State(ClangFormatStep step, String exeAbsPath) {
            this.version = step.version;
            this.style = step.style;
            this.args = new ArrayList<String>(2);
            this.args.add(exeAbsPath);
            if (this.style != null) {
                this.args.add("--style=" + this.style);
            }
        }

        String format(ProcessRunner runner, String input, File file) throws IOException, InterruptedException {
            String[] processArgs = this.args.toArray(new String[this.args.size() + 1]);
            processArgs[this.args.size()] = "--assume-filename=" + file.getName();
            return runner.exec(input.getBytes(StandardCharsets.UTF_8), processArgs).assertExitZero(StandardCharsets.UTF_8);
        }

        FormatterFunc.Closeable toFunc() {
            ProcessRunner runner = new ProcessRunner();
            return FormatterFunc.Closeable.of(runner, this::format);
        }
    }
}

