/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.sql;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterProperties;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.sql.DBeaverSQLFormatter;
import java.io.File;
import java.io.Serializable;

public class DBeaverSQLFormatterStep {
    private static final String NAME = "dbeaverSql";

    private DBeaverSQLFormatterStep() {
    }

    public static FormatterStep create(Iterable<File> files) {
        return FormatterStep.createLazy(NAME, () -> new State(files), State::createFormat);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final FileSignature settingsSignature;

        State(Iterable<File> settingsFiles) throws Exception {
            this.settingsSignature = FileSignature.signAsList(settingsFiles);
        }

        FormatterFunc createFormat() throws Exception {
            FormatterProperties preferences = FormatterProperties.from(this.settingsSignature.files());
            DBeaverSQLFormatter dbeaverSqlFormatter = new DBeaverSQLFormatter(preferences.getProperties());
            return dbeaverSqlFormatter::format;
        }
    }
}

