/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.java.ModuleHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class GoogleJavaFormatStep {
    private static final String DEFAULT_STYLE = "GOOGLE";
    private static final boolean DEFAULT_REFLOW_LONG_STRINGS = false;
    private static final boolean DEFAULT_REORDER_IMPORTS = false;
    private static final boolean DEFAULT_FORMAT_JAVADOC = true;
    static final String NAME = "google-java-format";
    static final String MAVEN_COORDINATE = "com.google.googlejavaformat:google-java-format";
    static final Jvm.Support<String> JVM_SUPPORT = Jvm.support("google-java-format").addMin(11, "1.8").addMin(16, "1.10.0").addMin(21, "1.17.0").add(11, "1.17.0");

    private GoogleJavaFormatStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return GoogleJavaFormatStep.create(GoogleJavaFormatStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return GoogleJavaFormatStep.create(version, DEFAULT_STYLE, provisioner);
    }

    public static FormatterStep create(String version, String style, Provisioner provisioner) {
        return GoogleJavaFormatStep.create(version, style, provisioner, false);
    }

    public static FormatterStep create(String version, String style, Provisioner provisioner, boolean reflowLongStrings) {
        return GoogleJavaFormatStep.create(MAVEN_COORDINATE, version, style, provisioner, reflowLongStrings);
    }

    public static FormatterStep create(String groupArtifact, String version, String style, Provisioner provisioner, boolean reflowLongStrings) {
        return GoogleJavaFormatStep.create(groupArtifact, version, style, provisioner, reflowLongStrings, false, true);
    }

    public static FormatterStep create(String groupArtifact, String version, String style, Provisioner provisioner, boolean reflowLongStrings, boolean reorderImports, boolean formatJavadoc) {
        Objects.requireNonNull(groupArtifact, "groupArtifact");
        if (groupArtifact.chars().filter(ch -> ch == 58).count() != 1L) {
            throw new IllegalArgumentException("groupArtifact must be in the form 'groupId:artifactId'");
        }
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(style, "style");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(NAME, groupArtifact, version, style, provisioner, reflowLongStrings, reorderImports, formatJavadoc), State::createFormat);
    }

    public static String defaultGroupArtifact() {
        return MAVEN_COORDINATE;
    }

    public static String defaultVersion() {
        return JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static String defaultStyle() {
        return DEFAULT_STYLE;
    }

    public static boolean defaultReflowLongStrings() {
        return false;
    }

    public static boolean defaultReorderImports() {
        return false;
    }

    public static boolean defaultFormatJavadoc() {
        return true;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final String stepName;
        final String version;
        final String style;
        final boolean reflowLongStrings;
        final boolean reorderImports;
        final boolean formatJavadoc;

        State(String stepName, String version, Provisioner provisioner) throws Exception {
            this(stepName, version, GoogleJavaFormatStep.DEFAULT_STYLE, provisioner);
        }

        State(String stepName, String version, String style, Provisioner provisioner) throws Exception {
            this(stepName, version, style, provisioner, false);
        }

        State(String stepName, String version, String style, Provisioner provisioner, boolean reflowLongStrings) throws Exception {
            this(stepName, GoogleJavaFormatStep.MAVEN_COORDINATE, version, style, provisioner, reflowLongStrings, false, true);
        }

        State(String stepName, String groupArtifact, String version, String style, Provisioner provisioner, boolean reflowLongStrings, boolean reorderImports, boolean formatJavadoc) throws Exception {
            JVM_SUPPORT.assertFormatterSupported(version);
            ModuleHelper.doOpenInternalPackagesIfRequired();
            this.jarState = JarState.from(groupArtifact + ":" + version, provisioner);
            this.stepName = stepName;
            this.version = version;
            this.style = style;
            this.reflowLongStrings = reflowLongStrings;
            this.reorderImports = reorderImports;
            this.formatJavadoc = formatJavadoc;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.java.GoogleJavaFormatFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            FormatterFunc googleJavaFormatFormatterFunc = (FormatterFunc)constructor.newInstance(this.version, this.style, this.reflowLongStrings, this.reorderImports, this.formatJavadoc);
            return JVM_SUPPORT.suggestLaterVersionOnError(this.version, googleJavaFormatFormatterFunc);
        }

        FormatterFunc createRemoveUnusedImportsOnly() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.java.GoogleJavaFormatRemoveUnusedImporterFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class);
            FormatterFunc googleJavaFormatRemoveUnusedImporterFormatterFunc = (FormatterFunc)constructor.newInstance(this.version);
            return JVM_SUPPORT.suggestLaterVersionOnError(this.version, googleJavaFormatRemoveUnusedImporterFormatterFunc);
        }
    }
}

