/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.markdown;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.markdown.LibMarkdownPreconditions;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreshMarkStep {
    private static final String DEFAULT_VERSION = "1.3.1";
    private static final String NAME = "freshmark";
    private static final String MAVEN_COORDINATE = "com.diffplug.freshmark:freshmark:";
    private static final String NASHORN_MAVEN_COORDINATE = "org.openjdk.nashorn:nashorn-core:";
    private static final String NASHORN_VERSION = "15.4";
    private static final String FORMATTER_CLASS = "com.diffplug.freshmark.FreshMark";
    private static final String FORMATTER_METHOD = "compile";

    private FreshMarkStep() {
    }

    public static FormatterStep create(ThrowingEx.Supplier<Map<String, ?>> properties, Provisioner provisioner) {
        return FreshMarkStep.create(FreshMarkStep.defaultVersion(), properties, provisioner);
    }

    public static FormatterStep create(String version, ThrowingEx.Supplier<Map<String, ?>> properties, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(provisioner, "provisioner");
        ArrayList<Object> mavenCoordinates = new ArrayList<Object>();
        mavenCoordinates.add(MAVEN_COORDINATE + version);
        if (Jvm.version() >= 15) {
            mavenCoordinates.add("com.diffplug.jscriptbox:jscriptbox:3.0.1");
            mavenCoordinates.add("org.openjdk.nashorn:nashorn-core:15.4");
        }
        return FormatterStep.createLazy(NAME, () -> new State(JarState.from(mavenCoordinates, provisioner), (Map)properties.get()), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final NavigableMap<String, ?> properties;

        State(JarState jarState, Map<String, ?> properties) {
            this.jarState = jarState;
            this.properties = new TreeMap(properties);
            LibMarkdownPreconditions.requireKeysAndValuesNonNull(this.properties);
        }

        FormatterFunc createFormat() throws Exception {
            Logger logger = LoggerFactory.getLogger(FreshMarkStep.class);
            Consumer<String> loggingStream = arg_0 -> ((Logger)logger).warn(arg_0);
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterClazz = classLoader.loadClass(FreshMarkStep.FORMATTER_CLASS);
            Object formatter = formatterClazz.getConstructor(Map.class, Consumer.class).newInstance(this.properties, loggingStream);
            Method method = formatterClazz.getMethod(FreshMarkStep.FORMATTER_METHOD, String.class);
            return input -> (String)method.invoke(formatter, input);
        }
    }
}

