/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Formatter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public class SpotlessTaskModern
extends SpotlessTask {
    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @InputFiles
    public FileCollection getTarget() {
        return super.getTarget();
    }

    @TaskAction
    public void performAction(InputChanges inputs) throws Exception {
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> target'");
        }
        if (!inputs.isIncremental()) {
            this.getLogger().info("Not incremental: removing prior outputs");
            this.getProject().delete(new Object[]{this.outputDirectory});
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        try (Formatter formatter = this.buildFormatter();){
            for (FileChange fileChange : inputs.getFileChanges(this.target)) {
                File input = fileChange.getFile();
                if (fileChange.getChangeType() == ChangeType.REMOVED) {
                    this.deletePreviousResult(input);
                    continue;
                }
                if (!input.isFile()) continue;
                this.processInputFile(formatter, input);
            }
        }
    }
}

