/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.spotless.extra.GitRatchet;
import java.io.File;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public class GitRatchetGradle
extends GitRatchet<File> {
    static void preventJGitFromCallingExecutables() {
        SystemReader reader = SystemReader.getInstance();
        SystemReader.setInstance((SystemReader)new DelegatingSystemReader(reader){

            @Override
            public String getenv(String variable) {
                if ("PATH".equals(variable)) {
                    return "";
                }
                return super.getenv(variable);
            }
        });
    }

    protected File getDir(File project) {
        return project;
    }

    @Nullable
    protected File getParent(File project) {
        return project.getParentFile();
    }

    static {
        GitRatchetGradle.preventJGitFromCallingExecutables();
    }

    static class DelegatingSystemReader
    extends SystemReader {
        final SystemReader reader;

        DelegatingSystemReader(SystemReader reader) {
            this.reader = reader;
        }

        public String getHostname() {
            return this.reader.getHostname();
        }

        public String getenv(String variable) {
            return this.reader.getProperty(variable);
        }

        public String getProperty(String key) {
            return this.reader.getProperty(key);
        }

        public FileBasedConfig openUserConfig(Config parent, FS fs) {
            return this.reader.openUserConfig(parent, fs);
        }

        public FileBasedConfig openSystemConfig(Config parent, FS fs) {
            return this.reader.openSystemConfig(parent, fs);
        }

        public FileBasedConfig openJGitConfig(Config parent, FS fs) {
            return this.reader.openJGitConfig(parent, fs);
        }

        public long getCurrentTime() {
            return this.reader.getCurrentTime();
        }

        public int getTimezone(long when) {
            return this.reader.getTimezone(when);
        }
    }
}

