/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.annotations.VisibleForTesting;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.extra.GitRatchet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class SpotlessTaskImpl
extends SpotlessTask {
    private transient Provider<SpotlessTaskService> taskServiceProvider;

    @Override
    @Internal
    abstract DirectoryProperty getProjectDir();

    void init(Provider<SpotlessTaskService> service) {
        this.taskServiceProvider = service;
        this.usesService(service);
        this.getTaskService().set(service);
        this.getProjectDir().set(this.getProject().getProjectDir());
    }

    @Internal
    Provider<SpotlessTaskService> getTaskServiceProvider() {
        return this.taskServiceProvider;
    }

    @Inject
    protected abstract FileSystemOperations getFs();

    @TaskAction
    public void performAction(InputChanges inputs) throws Exception {
        SpotlessTaskService taskService = (SpotlessTaskService)this.getTaskService().get();
        taskService.registerSourceAlreadyRan(this);
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> target'");
        }
        if (!inputs.isIncremental()) {
            this.getLogger().info("Not incremental: removing prior outputs");
            this.getFs().delete(d -> d.delete(new Object[]{this.outputDirectory}));
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        try (Formatter formatter = this.buildFormatter();){
            GitRatchetGradle ratchet = this.getRatchet();
            for (FileChange fileChange : inputs.getFileChanges(this.target)) {
                File input = fileChange.getFile();
                if (fileChange.getChangeType() == ChangeType.REMOVED) {
                    this.deletePreviousResult(input);
                    continue;
                }
                if (!input.isFile()) continue;
                this.processInputFile(ratchet, formatter, input);
            }
        }
    }

    @VisibleForTesting
    void processInputFile(@Nullable GitRatchet ratchet, Formatter formatter, File input) throws IOException {
        PaddedCell.DirtyState dirtyState;
        File output = this.getOutputFile(input);
        this.getLogger().debug("Applying format to {} and writing to {}", (Object)input, (Object)output);
        if (ratchet != null && ratchet.isClean((Object)((Directory)this.getProjectDir().get()).getAsFile(), this.getRootTreeSha(), input)) {
            dirtyState = PaddedCell.isClean();
        } else {
            try {
                dirtyState = PaddedCell.calculateDirtyState((Formatter)formatter, (File)input);
            }
            catch (IOException e) {
                throw new IOException("Issue processing file: " + input, e);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Issue processing file: " + input, e);
            }
        }
        if (dirtyState.isClean()) {
            Files.deleteIfExists(output.toPath());
        } else if (dirtyState.didNotConverge()) {
            this.getLogger().warn("Skipping '{}' because it does not converge.  Run {@code spotlessDiagnose} to understand why", (Object)input);
        } else {
            Path parentDir = output.toPath().getParent();
            if (parentDir == null) {
                throw new IllegalStateException("Every file has a parent folder. But not: " + output);
            }
            Files.createDirectories(parentDir, new FileAttribute[0]);
            Files.copy(input.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            this.getLogger().info(String.format("Writing clean file: %s", output));
            dirtyState.writeCanonicalTo(output);
        }
    }

    private void deletePreviousResult(File input) throws IOException {
        File output = this.getOutputFile(input);
        if (output.isDirectory()) {
            this.getFs().delete(d -> d.delete(new Object[]{output}));
        } else {
            Files.deleteIfExists(output.toPath());
        }
    }

    private File getOutputFile(File input) {
        File projectDir = ((Directory)this.getProjectDir().get()).getAsFile();
        String outputFileName = FormatExtension.relativize(projectDir, input);
        if (outputFileName == null) {
            throw new IllegalArgumentException(StringPrinter.buildString(printer -> {
                printer.println("Spotless error! All target files must be within the project dir.");
                printer.println("  project dir: " + projectDir.getAbsolutePath());
                printer.println("       target: " + input.getAbsolutePath());
            }));
        }
        return new File(this.outputDirectory, outputFileName);
    }
}

