/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.facebook.nailgun.NGUnixDomainSocketLibrary;
import com.facebook.nailgun.ReferenceCountedFileDescriptor;
import com.sun.jna.LastErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;

public class NGUnixDomainSocket
extends Socket {
    private final ReferenceCountedFileDescriptor fd;
    private final InputStream is;
    private final OutputStream os;

    public NGUnixDomainSocket(int fd) {
        this.fd = new ReferenceCountedFileDescriptor(fd);
        this.is = new NGUnixDomainSocketInputStream();
        this.os = new NGUnixDomainSocketOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void shutdownInput() throws IOException {
        this.doShutdown(0);
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.doShutdown(1);
    }

    private void doShutdown(int how) throws IOException {
        try {
            int socketFd = this.fd.acquire();
            if (socketFd != -1) {
                NGUnixDomainSocketLibrary.shutdown(socketFd, how);
            }
        }
        catch (LastErrorException e) {
            throw new IOException(e);
        }
        finally {
            this.fd.release();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.fd.close();
        }
        catch (LastErrorException e) {
            throw new IOException(e);
        }
    }

    private class NGUnixDomainSocketOutputStream
    extends OutputStream {
        private NGUnixDomainSocketOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(1);
            buf.put(0, (byte)(0xFF & b));
            this.doWrite(buf);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            this.doWrite(buf);
        }

        private void doWrite(ByteBuffer buf) throws IOException {
            try {
                int fdToWrite = NGUnixDomainSocket.this.fd.acquire();
                if (fdToWrite == -1) {
                    return;
                }
                int ret = NGUnixDomainSocketLibrary.write(fdToWrite, buf, buf.remaining());
                if (ret != buf.remaining()) {
                    throw new IOException("Could not write " + buf.remaining() + " bytes as requested (wrote " + ret + " bytes instead)");
                }
            }
            catch (LastErrorException e) {
                throw new IOException(e);
            }
            finally {
                NGUnixDomainSocket.this.fd.release();
            }
        }
    }

    private class NGUnixDomainSocketInputStream
    extends InputStream {
        private NGUnixDomainSocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(1);
            int result = this.doRead(buf) == 0 ? -1 : 0xFF & buf.get();
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            int result = this.doRead(buf);
            if (result == 0) {
                result = -1;
            }
            return result;
        }

        private int doRead(ByteBuffer buf) throws IOException {
            try {
                int fdToRead = NGUnixDomainSocket.this.fd.acquire();
                if (fdToRead == -1) {
                    int n = -1;
                    return n;
                }
                int n = NGUnixDomainSocketLibrary.read(fdToRead, buf, buf.remaining());
                return n;
            }
            catch (LastErrorException e) {
                throw new IOException(e);
            }
            finally {
                NGUnixDomainSocket.this.fd.release();
            }
        }
    }
}

