/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nailgun;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class NGUnixDomainSocketLibrary {
    public static final int PF_LOCAL = 1;
    public static final int AF_LOCAL = 1;
    public static final int SOCK_STREAM = 1;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;
    private static final boolean HAS_SUN_LEN = Platform.isMac() || Platform.isFreeBSD() || Platform.isNetBSD() || Platform.isOpenBSD() || Platform.iskFreeBSD();

    private NGUnixDomainSocketLibrary() {
    }

    public static native int socket(int var0, int var1, int var2) throws LastErrorException;

    public static native int bind(int var0, SockaddrUn var1, int var2) throws LastErrorException;

    public static native int listen(int var0, int var1) throws LastErrorException;

    public static native int connect(int var0, SockaddrUn var1, int var2) throws LastErrorException;

    public static native int accept(int var0, SockaddrUn var1, IntByReference var2) throws LastErrorException;

    public static native int read(int var0, ByteBuffer var1, int var2) throws LastErrorException;

    public static native int write(int var0, ByteBuffer var1, int var2) throws LastErrorException;

    public static native int close(int var0) throws LastErrorException;

    public static native int shutdown(int var0, int var1) throws LastErrorException;

    public static native int unlink(String var0);

    static {
        Native.register((String)Platform.C_LIBRARY_NAME);
    }

    public static class SockaddrUn
    extends Structure
    implements Structure.ByReference {
        public SunFamily sunFamily = new SunFamily();
        public byte[] sunPath = new byte[104];

        public SockaddrUn() {
            if (HAS_SUN_LEN) {
                this.sunFamily.sunLenAndFamily = new SunLenAndFamily();
                this.sunFamily.setType(SunLenAndFamily.class);
            } else {
                this.sunFamily.setType(Short.TYPE);
            }
            this.allocateMemory();
        }

        public SockaddrUn(String path) throws IOException {
            byte[] pathBytes = path.getBytes();
            if (pathBytes.length > this.sunPath.length - 1) {
                throw new IOException("Cannot fit name [" + path + "] in maximum unix domain socket length");
            }
            System.arraycopy(pathBytes, 0, this.sunPath, 0, pathBytes.length);
            this.sunPath[pathBytes.length] = 0;
            if (HAS_SUN_LEN) {
                int len = this.fieldOffset("sunPath") + pathBytes.length;
                this.sunFamily.sunLenAndFamily = new SunLenAndFamily();
                this.sunFamily.sunLenAndFamily.sunLen = (byte)len;
                this.sunFamily.sunLenAndFamily.sunFamily = 1;
                this.sunFamily.setType(SunLenAndFamily.class);
            } else {
                this.sunFamily.sunFamily = 1;
                this.sunFamily.setType(Short.TYPE);
            }
            this.allocateMemory();
        }

        protected List getFieldOrder() {
            return Arrays.asList("sunFamily", "sunPath");
        }

        public static class SunFamily
        extends Union {
            public SunLenAndFamily sunLenAndFamily;
            public short sunFamily;
        }

        public static class SunLenAndFamily
        extends Structure {
            public byte sunLen;
            public byte sunFamily;

            protected List getFieldOrder() {
                return Arrays.asList("sunLen", "sunFamily");
            }
        }
    }
}

