/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/fasterxml/jackson/module/kotlin/RegexDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lkotlin/text/Regex;", "<init>", "()V", "readResolve", "", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "jackson-module-kotlin"})
public final class RegexDeserializer
extends StdDeserializer<Regex> {
    @NotNull
    public static final RegexDeserializer INSTANCE = new RegexDeserializer();

    private RegexDeserializer() {
        super(Regex.class);
    }

    private final Object readResolve() {
        return INSTANCE;
    }

    @NotNull
    public Regex deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JsonNode node = ctxt.readTree(p);
        if (node.isTextual()) {
            String string = node.asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            return new Regex(string);
        }
        if (node.isObject()) {
            Set set;
            String pattern = node.get("pattern").asText();
            if (node.has("options")) {
                JsonNode optionsNode = node.get("options");
                if (!optionsNode.isArray()) {
                    throw new IllegalStateException("Expected an array of strings for RegexOptions, but type was " + node.getNodeType());
                }
                Iterator iterator = optionsNode.elements();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
                set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), RegexDeserializer::deserialize$lambda$0));
            } else {
                set = SetsKt.emptySet();
            }
            Set options = set;
            Intrinsics.checkNotNull((Object)pattern);
            return new Regex(pattern, options);
        }
        throw new IllegalStateException("Expected a string or an object to deserialize a Regex, but type was " + node.getNodeType());
    }

    private static final RegexOption deserialize$lambda$0(JsonNode it) {
        String string = it.asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        return RegexOption.valueOf((String)string);
    }
}

