/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.Comparator;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class OrderComparator
implements Comparator<Object> {
    public Comparator<Object> withSourceProvider(OrderSourceProvider sourceProvider) {
        return (o1, o2) -> this.doCompare(o1, o2, sourceProvider);
    }

    @Override
    public int compare(@Nullable Object o1, @Nullable Object o2) {
        return this.doCompare(o1, o2, null);
    }

    private int doCompare(@Nullable Object o1, @Nullable Object o2, @Nullable OrderSourceProvider sourceProvider) {
        int i2;
        boolean p1 = o1 instanceof PriorityOrdered;
        boolean p2 = o2 instanceof PriorityOrdered;
        if (p1 && !p2) {
            return -1;
        }
        if (p2 && !p1) {
            return 1;
        }
        int i1 = this.getOrder(o1, sourceProvider);
        return i1 < (i2 = this.getOrder(o2, sourceProvider)) ? -1 : (i1 > i2 ? 1 : 0);
    }

    private int getOrder(@Nullable Object obj, @Nullable OrderSourceProvider sourceProvider) {
        Object orderSource;
        Integer order = null;
        if (obj != null && sourceProvider != null && (orderSource = sourceProvider.getOrderSource(obj)) != null) {
            if (orderSource.getClass().isArray()) {
                Object source;
                Object[] sources;
                Object[] objectArray = sources = ObjectUtils.toObjectArray(orderSource);
                int n = objectArray.length;
                for (int i = 0; i < n && (order = this.findOrder(source = objectArray[i])) == null; ++i) {
                }
            } else {
                order = this.findOrder(orderSource);
            }
        }
        return order != null ? order.intValue() : this.getOrder(obj);
    }

    protected int getOrder(@Nullable Object obj) {
        Integer order;
        if (obj != null && (order = this.findOrder(obj)) != null) {
            return order;
        }
        return Integer.MAX_VALUE;
    }

    @Nullable
    protected Integer findOrder(Object obj) {
        return obj instanceof Ordered ? Integer.valueOf(((Ordered)obj).getOrder()) : null;
    }

    @Nullable
    public Integer getPriority(Object obj) {
        return null;
    }

    @FunctionalInterface
    public static interface OrderSourceProvider {
        @Nullable
        public Object getOrderSource(Object var1);
    }
}

