/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import java.io.File;
import java.io.IOException;
import org.sonatype.plexus.build.incremental.BuildContext;

class FileMessage {
    private final Throwable cause;
    private final int column;
    private final File file;
    private final int line;
    private final String message;
    private final int severity;

    public FileMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        this.file = file;
        this.line = line;
        this.column = column;
        this.severity = severity;
        this.cause = cause;
        this.message = message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public int getColumn() {
        return this.column;
    }

    public File getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public String getMessage() {
        return this.message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void addTo(BuildContext context) {
        if (context == null) {
            return;
        }
        File cFile = null;
        try {
            cFile = this.file.getCanonicalFile();
        }
        catch (IOException e) {
            cFile = this.file;
        }
        try {
            context.addMessage(cFile, this.line, this.column, this.message, this.severity, this.cause);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

