/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.springbatchrest.util.adhoc;

import com.github.chrisgleissner.springbatchrest.util.adhoc.JobBuilder;
import com.github.chrisgleissner.springbatchrest.util.adhoc.QuartzJobLauncher;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdHocScheduler {
    private static final Logger log = LoggerFactory.getLogger(AdHocScheduler.class);
    private static final String GROUP_NAME = "group";
    private final JobBuilder jobBuilder;
    private Scheduler scheduler;
    private JobBuilderFactory jobBuilderFactory;
    private StepBuilderFactory stepBuilderFactory;

    @Autowired
    public AdHocScheduler(JobBuilder jobBuilder, Scheduler scheduler, JobBuilderFactory jobBuilderFactory, StepBuilderFactory stepBuilderFactory) {
        this.jobBuilder = jobBuilder;
        this.scheduler = scheduler;
        this.jobBuilderFactory = jobBuilderFactory;
        this.stepBuilderFactory = stepBuilderFactory;
    }

    public synchronized void schedule(String jobName, Job job, String cronExpression) {
        log.debug("Scheduling job {} with CRON expression {}", (Object)jobName, (Object)cronExpression);
        try {
            this.jobBuilder.registerJob(job);
            JobDetail jobDetail = org.quartz.JobBuilder.newJob(QuartzJobLauncher.class).withIdentity(jobName, GROUP_NAME).usingJobData("jobName", jobName).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName + "-trigger", GROUP_NAME).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).forJob(jobName, GROUP_NAME).build();
            this.scheduler.unscheduleJob(trigger.getKey());
            this.scheduler.scheduleJob(jobDetail, trigger);
            log.info("Scheduled job {} with CRON expression {}", (Object)jobName, (Object)cronExpression);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Can't schedule job %s with cronExpression %s", jobName, cronExpression), e);
        }
    }

    public synchronized void start() {
        try {
            if (!this.scheduler.isStarted()) {
                this.scheduler.start();
                log.info("Started Quartz scheduler");
            } else {
                log.warn("Quartz scheduler already started");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start Quartz scheduler", e);
        }
    }

    public synchronized void pause() {
        try {
            if (this.scheduler.isStarted() && !this.scheduler.isInStandbyMode()) {
                this.scheduler.pauseAll();
                log.info("Paused Quartz scheduler");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not pause Quartz scheduler", e);
        }
    }

    public synchronized void resume() {
        try {
            if (this.scheduler.isStarted() && this.scheduler.isInStandbyMode()) {
                this.scheduler.resumeAll();
                log.info("Resumed Quartz scheduler");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not resumse Quartz scheduler", e);
        }
    }

    public synchronized void stop() {
        try {
            if (this.scheduler.isStarted() && !this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
                log.info("Stopped Quartz scheduler");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop Quartz scheduler", e);
        }
    }

    public JobBuilderFactory jobs() {
        return this.jobBuilderFactory;
    }

    public StepBuilderFactory steps() {
        return this.stepBuilderFactory;
    }
}

