/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.springbatchrest.util.adhoc;

import com.github.chrisgleissner.springbatchrest.util.adhoc.JobConfig;
import com.github.chrisgleissner.springbatchrest.util.adhoc.property.JobPropertyResolvers;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.batch.operations.BatchRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class AdHocStarter {
    private static final Logger log = LoggerFactory.getLogger(AdHocStarter.class);
    private final JobLocator jobLocator;
    private final SimpleJobLauncher asyncJobLauncher;
    private final SimpleJobLauncher syncJobLauncher;
    private final JobPropertyResolvers jobPropertyResolvers;
    private final boolean addUniqueJobParameter;

    public AdHocStarter(JobLocator jobLocator, JobRepository jobRepository, JobPropertyResolvers jobPropertyResolvers, @Value(value="${com.github.chrisgleissner.springbatchrest.addUniqueJobParameter:true}") boolean addUniqueJobParameter) {
        this.jobLocator = jobLocator;
        this.asyncJobLauncher = this.jobLauncher((TaskExecutor)new SimpleAsyncTaskExecutor(), jobRepository);
        this.syncJobLauncher = this.jobLauncher((TaskExecutor)new SyncTaskExecutor(), jobRepository);
        this.jobPropertyResolvers = jobPropertyResolvers;
        this.addUniqueJobParameter = addUniqueJobParameter;
        log.info("Adding unique job parameter: {}", (Object)addUniqueJobParameter);
    }

    private SimpleJobLauncher jobLauncher(TaskExecutor taskExecutor, JobRepository jobRepository) {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(jobRepository);
        jobLauncher.setTaskExecutor(taskExecutor);
        return jobLauncher;
    }

    public JobExecution start(JobConfig jobConfig) {
        try {
            Job job = this.jobLocator.getJob(jobConfig.getName());
            this.jobPropertyResolvers.started(jobConfig);
            Map<String, JobParameter> params = Optional.ofNullable(jobConfig.getProperties()).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new JobParameter((String)e.getValue())));
            if (this.addUniqueJobParameter) {
                params.put("uuid", new JobParameter(UUID.randomUUID().toString()));
            }
            JobParameters jobParameters = new JobParameters(params);
            log.info("Starting {} with {}", (Object)jobConfig.getName(), (Object)jobConfig);
            SimpleJobLauncher jobLauncher = jobConfig.isAsynchronous() ? this.asyncJobLauncher : this.syncJobLauncher;
            return jobLauncher.run(job, jobParameters);
        }
        catch (JobExecutionException e2) {
            throw new BatchRuntimeException(String.format("Failed to start job '%s' with %s. Reason: %s", jobConfig.getName(), jobConfig, e2.getMessage()), (Throwable)e2);
        }
        catch (Exception e3) {
            throw new RuntimeException(String.format("Failed to start job '%s' with %s. Reason: %s", jobConfig.getName(), jobConfig, e3.getMessage()), e3);
        }
    }
}

