/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.springbatchrest.util.adhoc;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobBuilder {
    private final JobRegistry jobRegistry;
    private final JobBuilderFactory jobs;
    private final StepBuilderFactory steps;

    @Autowired
    public JobBuilder(JobRegistry jobRegistry, JobBuilderFactory jobs, StepBuilderFactory steps) {
        this.jobRegistry = jobRegistry;
        this.jobs = jobs;
        this.steps = steps;
    }

    public Job registerJob(final Job job) {
        this.jobRegistry.unregister(job.getName());
        try {
            this.jobRegistry.register(new JobFactory(){

                public Job createJob() {
                    return job;
                }

                public String getJobName() {
                    return job.getName();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create " + job.getName(), e);
        }
        return job;
    }

    public Job createJob(String name, Runnable r) {
        return this.registerJob(((org.springframework.batch.core.job.builder.JobBuilder)this.jobs.get(name).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start((Step)((StepBuilder)this.steps.get("step").allowStartIfComplete(true)).tasklet((Tasklet)new RunnableTaskletAdapter(r)).build()).build());
    }

    private class RunnableTaskletAdapter
    implements Tasklet {
        private Runnable r;

        public RunnableTaskletAdapter(Runnable r) {
            this.r = r;
        }

        public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) {
            this.r.run();
            return RepeatStatus.FINISHED;
        }
    }
}

