/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.springbatchrest.util.adhoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class JobConfig {
    private String name;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean asynchronous;

    JobConfig(String name, Map<String, String> properties, boolean asynchronous) {
        this.name = name;
        this.properties = properties;
        this.asynchronous = asynchronous;
    }

    public static JobConfigBuilder builder() {
        return new JobConfigBuilder();
    }

    public JobConfigBuilder toBuilder() {
        JobConfigBuilder builder = new JobConfigBuilder().name(this.name).asynchronous(this.asynchronous);
        if (this.properties != null) {
            builder.properties(this.properties);
        }
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobConfig)) {
            return false;
        }
        JobConfig other = (JobConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        return this.isAsynchronous() == other.isAsynchronous();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        result = result * 59 + (this.isAsynchronous() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "JobConfig(name=" + this.getName() + ", properties=" + this.getProperties() + ", asynchronous=" + this.isAsynchronous() + ")";
    }

    public static class JobConfigBuilder {
        private String name;
        private ArrayList<String> properties$key;
        private ArrayList<String> properties$value;
        private boolean asynchronous;

        JobConfigBuilder() {
        }

        public JobConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public JobConfigBuilder property(String propertyKey, String propertyValue) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            this.properties$key.add(propertyKey);
            this.properties$value.add(propertyValue);
            return this;
        }

        public JobConfigBuilder properties(Map<? extends String, ? extends String> properties) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : properties.entrySet()) {
                this.properties$key.add($lombokEntry.getKey());
                this.properties$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public JobConfigBuilder clearProperties() {
            if (this.properties$key != null) {
                this.properties$key.clear();
                this.properties$value.clear();
            }
            return this;
        }

        public JobConfigBuilder asynchronous(boolean asynchronous) {
            this.asynchronous = asynchronous;
            return this;
        }

        public JobConfig build() {
            Map<String, String> properties;
            switch (this.properties$key == null ? 0 : this.properties$key.size()) {
                case 0: {
                    properties = Collections.emptyMap();
                    break;
                }
                case 1: {
                    properties = Collections.singletonMap(this.properties$key.get(0), this.properties$value.get(0));
                    break;
                }
                default: {
                    properties = new LinkedHashMap(this.properties$key.size() < 0x40000000 ? 1 + this.properties$key.size() + (this.properties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.properties$key.size(); ++$i) {
                        properties.put(this.properties$key.get($i), this.properties$value.get($i));
                    }
                    properties = Collections.unmodifiableMap(properties);
                }
            }
            return new JobConfig(this.name, properties, this.asynchronous);
        }

        public String toString() {
            return "JobConfig.JobConfigBuilder(name=" + this.name + ", properties$key=" + this.properties$key + ", properties$value=" + this.properties$value + ", asynchronous=" + this.asynchronous + ")";
        }
    }
}

