/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.springbatchrest.util.adhoc;

import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class QuartzJobLauncher
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobLauncher.class);
    public static final String JOB_NAME = "jobName";
    public static final String JOB_LOCATOR = "jobLocator";
    public static final String JOB_LAUNCHER = "jobLauncher";

    protected void executeInternal(JobExecutionContext context) {
        String jobName = null;
        try {
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            jobName = dataMap.getString(JOB_NAME);
            JobLocator jobLocator = (JobLocator)context.getScheduler().getContext().get((Object)JOB_LOCATOR);
            JobLauncher jobLauncher = (JobLauncher)context.getScheduler().getContext().get((Object)JOB_LAUNCHER);
            Job job = jobLocator.getJob(jobName);
            log.info("Starting {}", (Object)job.getName());
            JobExecution jobExecution = jobLauncher.run(job, new JobParameters());
            log.info("{}_{} was completed successfully", (Object)job.getName(), (Object)jobExecution.getId());
        }
        catch (Exception e) {
            log.error("Job {} failed", jobName, (Object)e);
        }
    }
}

