/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.springbatchrest.util.adhoc.property;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JobExecutionAspect {
    private static final Logger log = LoggerFactory.getLogger(JobExecutionAspect.class);
    private Set<Consumer<JobExecution>> consumers = new LinkedHashSet<Consumer<JobExecution>>();

    public void register(Consumer<JobExecution> consumer) {
        this.consumers.add(consumer);
    }

    @Before(value="within(org.springframework.batch.core.repository.JobRepository+) && execution(* update(..)) && args(jobExecution)")
    public void jobExecutionUpdated(JobExecution jobExecution) {
        if (jobExecution.getStatus().isUnsuccessful()) {
            log.error("{} {}: {}", new Object[]{jobExecution.getStatus().name(), jobExecution.getJobInstance().getJobName(), jobExecution});
        } else {
            log.info("{} {}: {}", new Object[]{jobExecution.getStatus().name(), jobExecution.getJobInstance().getJobName(), jobExecution});
        }
        this.consumers.forEach(l -> l.accept(jobExecution));
    }
}

