/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.springbatchrest.util.adhoc.property;

import com.github.chrisgleissner.springbatchrest.util.adhoc.JobConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public class JobPropertyResolver
extends PropertySourcesPropertyResolver {
    private final JobConfig jobConfig;

    public JobPropertyResolver(JobConfig jobConfig, Environment env) {
        super(JobPropertyResolver.propertySources(jobConfig, env));
        this.jobConfig = jobConfig;
    }

    private static PropertySources propertySources(JobConfig jobConfig, Environment env) {
        MutablePropertySources propertySources = new MutablePropertySources();
        HashMap jobProperties = new HashMap(Optional.ofNullable(jobConfig.getProperties()).orElse(Collections.emptyMap()));
        propertySources.addFirst((PropertySource)new MapPropertySource(jobConfig.getName(), jobProperties));
        ((AbstractEnvironment)env).getPropertySources().forEach(ps -> propertySources.addLast(ps));
        return propertySources;
    }

    public String toString() {
        return String.format("Properties for job %s: %s", this.jobConfig.getName(), this.jobConfig.getProperties());
    }
}

