/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.springbatchrest.util.adhoc.property;

import com.github.chrisgleissner.springbatchrest.util.adhoc.JobConfig;
import com.github.chrisgleissner.springbatchrest.util.adhoc.property.JobExecutionAspect;
import com.github.chrisgleissner.springbatchrest.util.adhoc.property.JobPropertyResolver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.stereotype.Component;

@Component
public class JobPropertyResolvers
implements Consumer<JobExecution> {
    private static final Logger log = LoggerFactory.getLogger(JobPropertyResolvers.class);
    public static JobPropertyResolvers JobProperties;
    private Environment env;
    private Map<String, JobPropertyResolver> resolvers = new ConcurrentHashMap<String, JobPropertyResolver>();

    @Autowired
    public JobPropertyResolvers(Environment env, JobExecutionAspect jobExecutionAspect) {
        this.env = env;
        jobExecutionAspect.register(this);
        JobProperties = this;
    }

    public PropertyResolver of(String jobName) {
        JobPropertyResolver jobPropertyResolver = this.resolvers.get(jobName);
        return jobPropertyResolver == null ? this.env : jobPropertyResolver;
    }

    public void started(JobConfig jobConfig) {
        String jobName = jobConfig.getName();
        JobPropertyResolver resolver = new JobPropertyResolver(jobConfig, this.env);
        this.resolvers.put(jobName, resolver);
        log.info("Enabled {}", (Object)resolver);
    }

    @Override
    public void accept(JobExecution je) {
        JobPropertyResolver resolver;
        if (!je.isRunning() && (resolver = this.resolvers.remove(je.getJobInstance().getJobName())) != null) {
            log.info("Disabled {}", (Object)je.getJobInstance().getJobName());
        }
    }
}

