/*
 * Decompiled with CFR 0.152.
 */
package dasniko.testcontainers.keycloak;

import dasniko.testcontainers.keycloak.HttpsClientAuth;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FilenameUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jetbrains.annotations.NotNull;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.utility.MountableFile;

public abstract class ExtendableKeycloakContainer<SELF extends ExtendableKeycloakContainer<SELF>>
extends GenericContainer<SELF> {
    public static final String MASTER_REALM = "master";
    public static final String ADMIN_CLI_CLIENT = "admin-cli";
    public static final WaitStrategy LOG_WAIT_STRATEGY = Wait.forLogMessage((String)".*Running the server in development mode\\. DO NOT use this configuration in production.*\\n", (int)1);
    private static final String KEYCLOAK_IMAGE = "quay.io/keycloak/keycloak";
    private static final String KEYCLOAK_VERSION = "26.3";
    private static final int KEYCLOAK_PORT_HTTP = 8080;
    private static final int KEYCLOAK_PORT_HTTPS = 8443;
    private static final int KEYCLOAK_PORT_DEBUG = 8787;
    private static final int KEYCLOAK_PORT_MGMT = 9000;
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(2L);
    private static final int DEFAULT_INITIAL_RAM_PERCENTAGE = 1;
    private static final int DEFAULT_MAX_RAM_PERCENTAGE = 5;
    private static final String KEYCLOAK_START_DEV_COMMAND = "start-dev";
    private static final String KEYCLOAK_START_PRODUCTION_COMMAND = "start";
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_CONTEXT_PATH = "";
    private static final String KEYCLOAK_HOME_DIR = "/opt/keycloak";
    private static final String KEYCLOAK_CONF_DIR = "/opt/keycloak/conf";
    private static final String DEFAULT_KEYCLOAK_PROVIDERS_NAME = "providers.jar";
    private static final String DEFAULT_KEYCLOAK_PROVIDERS_LOCATION = "/opt/keycloak/providers";
    private static final String DEFAULT_REALM_IMPORT_FILES_LOCATION = "/opt/keycloak/data/import/";
    private static final String KEYSTORE_FILE_IN_CONTAINER = "/opt/keycloak/conf/server.keystore";
    private static final String TRUSTSTORE_FILE_IN_CONTAINER = "/opt/keycloak/conf/server.truststore";
    private String startupCommand = "start-dev";
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String contextPath = "";
    private int initialRamPercentage = 1;
    private int maxRamPercentage = 5;
    private final Set<String> importFiles;
    private String tlsCertificateFilename;
    private String tlsCertificateKeyFilename;
    private String tlsKeystoreFilename;
    private String tlsKeystorePassword;
    private String tlsTruststoreFilename;
    private String tlsTruststorePassword;
    private List<String> tlsTrustedCertificateFilenames;
    private boolean useTls = false;
    private boolean disabledCaching = false;
    private boolean metricsEnabled = false;
    private boolean debugEnabled = false;
    private int debugHostPort;
    private boolean debugSuspend = false;
    private HttpsClientAuth httpsClientAuth = HttpsClientAuth.NONE;
    private boolean useVerbose = false;
    private String[] featuresEnabled = null;
    private String[] featuresDisabled = null;
    private Duration startupTimeout = DEFAULT_STARTUP_TIMEOUT;
    private boolean customWaitStrategySet = false;
    private List<String> providerClassLocations;
    private List<File> providerLibsLocations;
    private List<String> customCommandParts;
    private boolean bootstrapAdmin = true;
    private boolean optimizeFlag = false;

    public ExtendableKeycloakContainer() {
        this("quay.io/keycloak/keycloak:26.3");
    }

    public ExtendableKeycloakContainer(String dockerImageName) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{8080, 8443, 9000});
        this.importFiles = new HashSet<String>();
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(this.logger()));
    }

    protected void configure() {
        ArrayList<String> commandParts = new ArrayList<String>();
        if (this.useVerbose) {
            commandParts.add("--verbose");
        }
        commandParts.add(this.startupCommand);
        if (!this.contextPath.equals(KEYCLOAK_CONTEXT_PATH)) {
            this.withEnv("KC_HTTP_RELATIVE_PATH", this.contextPath);
        }
        if (this.featuresEnabled != null) {
            this.withEnv("KC_FEATURES", String.join((CharSequence)",", this.featuresEnabled));
        }
        if (this.featuresDisabled != null) {
            this.withEnv("KC_FEATURES_DISABLED", String.join((CharSequence)",", this.featuresDisabled));
        }
        if (this.bootstrapAdmin) {
            this.withEnv("KC_BOOTSTRAP_ADMIN_USERNAME", this.adminUsername);
            this.withEnv("KC_BOOTSTRAP_ADMIN_PASSWORD", this.adminPassword);
        }
        this.withEnv("JAVA_OPTS_KC_HEAP", String.format("-XX:InitialRAMPercentage=%d -XX:MaxRAMPercentage=%d", this.initialRamPercentage, this.maxRamPercentage));
        if (this.useTls && this.isNotBlank(this.tlsCertificateFilename)) {
            String tlsCertFilePath = "/opt/keycloak/conf/tls.crt";
            String tlsCertKeyFilePath = "/opt/keycloak/conf/tls.key";
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertificateFilename), tlsCertFilePath);
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertificateKeyFilename), tlsCertKeyFilePath);
            this.withEnv("KC_HTTPS_CERTIFICATE_FILE", tlsCertFilePath);
            this.withEnv("KC_HTTPS_CERTIFICATE_KEY_FILE", tlsCertKeyFilePath);
        } else if (this.useTls && this.isNotBlank(this.tlsKeystoreFilename)) {
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsKeystoreFilename), KEYSTORE_FILE_IN_CONTAINER);
            this.withEnv("KC_HTTPS_KEY_STORE_FILE", KEYSTORE_FILE_IN_CONTAINER);
            this.withEnv("KC_HTTPS_KEY_STORE_PASSWORD", this.tlsKeystorePassword);
        }
        if (this.useTls && this.isNotBlank(this.tlsTruststoreFilename)) {
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsTruststoreFilename), TRUSTSTORE_FILE_IN_CONTAINER);
            this.withEnv("KC_HTTPS_TRUST_STORE_FILE", TRUSTSTORE_FILE_IN_CONTAINER);
            this.withEnv("KC_HTTPS_TRUST_STORE_PASSWORD", this.tlsTruststorePassword);
        }
        if (this.isNotEmpty(this.tlsTrustedCertificateFilenames)) {
            ArrayList truststorePaths = new ArrayList();
            this.tlsTrustedCertificateFilenames.forEach(certificateFilename -> {
                String certPathInContainer = KEYCLOAK_CONF_DIR + (certificateFilename.startsWith("/") ? KEYCLOAK_CONTEXT_PATH : "/") + certificateFilename;
                this.withCopyFileToContainer(MountableFile.forClasspathResource((String)certificateFilename), certPathInContainer);
                truststorePaths.add(certPathInContainer);
            });
            this.withEnv("KC_TRUSTSTORE_PATHS", String.join((CharSequence)",", truststorePaths));
        }
        if (!this.optimizeFlag) {
            this.withEnv("KC_HTTPS_CLIENT_AUTH", this.httpsClientAuth.toString());
            this.withEnv("KC_HTTPS_MANAGEMENT_CLIENT_AUTH", HttpsClientAuth.NONE.toString());
            this.withEnv("KC_METRICS_ENABLED", Boolean.toString(this.metricsEnabled));
        } else {
            commandParts.add("--optimized");
        }
        this.withEnv("KC_HEALTH_ENABLED", Boolean.toString(Boolean.TRUE));
        if (!this.customWaitStrategySet) {
            HttpWaitStrategy waitStrategy = Wait.forHttp((String)(this.contextPath + "/health/started")).forPort(9000);
            if (this.useTls) {
                waitStrategy = waitStrategy.usingTls().allowInsecure();
            }
            this.setWaitStrategy(waitStrategy.withStartupTimeout(this.startupTimeout));
        }
        if (this.providerClassLocations != null && !this.providerClassLocations.isEmpty()) {
            AtomicInteger index = new AtomicInteger(0);
            this.providerClassLocations.forEach(providerClassLocation -> this.createKeycloakExtensionDeployment(DEFAULT_KEYCLOAK_PROVIDERS_LOCATION, index.getAndIncrement() + "_providers.jar", (String)providerClassLocation));
        }
        if (this.providerLibsLocations != null) {
            this.providerLibsLocations.forEach(file -> {
                String containerPath = "/opt/keycloak/providers/" + file.getName();
                this.withCopyFileToContainer(MountableFile.forHostPath((String)file.getAbsolutePath()), containerPath);
            });
        }
        commandParts.add("--import-realm");
        if (!this.importFiles.isEmpty()) {
            for (String importFile : this.importFiles) {
                String importFileInContainer = DEFAULT_REALM_IMPORT_FILES_LOCATION + FilenameUtils.getName((String)importFile);
                this.withCopyFileToContainer(MountableFile.forClasspathResource((String)importFile, (Integer)420), importFileInContainer);
            }
        }
        if (!this.disabledCaching) {
            this.withEnv("KC_SPI_THEME__CACHE_THEMES", String.valueOf(true));
            this.withEnv("KC_SPI_THEME__CACHE_TEMPLATES", String.valueOf(true));
            this.withEnv("KC_SPI_THEME__STATIC_MAX_AGE", String.valueOf(2592000));
        }
        if (this.debugEnabled) {
            this.withEnv("DEBUG", Boolean.toString(Boolean.TRUE));
            this.withEnv("DEBUG_PORT", "*:8787");
            if (this.debugHostPort > 0) {
                this.addFixedExposedPort(this.debugHostPort, 8787);
            } else {
                this.addExposedPort(8787);
            }
            if (this.debugSuspend) {
                this.withEnv("DEBUG_SUSPEND", "y");
            }
        }
        if (this.customCommandParts != null) {
            this.logger().warn("You are using custom command parts. Container behavior and configuration may be corrupted. You are self responsible for proper behavior and functionality!\nCustomCommandParts: {}", this.customCommandParts);
            commandParts.addAll(this.customCommandParts);
        }
        this.setCommand(commandParts.toArray(new String[0]));
    }

    public SELF withCommand(String cmd) {
        throw new IllegalStateException("You are trying to set custom container commands, which is not supported by this Testcontainer. Try using the withCustomCommand() method.");
    }

    public SELF withCommand(String ... commandParts) {
        throw new IllegalStateException("You are trying to set custom container commands, which is not supported by this Testcontainer. Try using the withCustomCommand() method.");
    }

    public SELF waitingFor(@NotNull WaitStrategy waitStrategy) {
        this.customWaitStrategySet = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)super.waitingFor(waitStrategy)));
    }

    public SELF withNightly() {
        this.setDockerImageName("quay.io/keycloak/keycloak:nightly");
        this.withImagePullPolicy(PullPolicy.ageBased((Duration)Duration.ofHours(12L)));
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withCustomCommand(String cmd) {
        if (this.customCommandParts == null) {
            this.customCommandParts = new ArrayList<String>();
        }
        this.customCommandParts.add(cmd);
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public void createKeycloakExtensionProvider(String extensionClassFolder) {
        this.createKeycloakExtensionDeployment(DEFAULT_KEYCLOAK_PROVIDERS_LOCATION, DEFAULT_KEYCLOAK_PROVIDERS_NAME, extensionClassFolder);
    }

    protected void createKeycloakExtensionDeployment(String deploymentLocation, String extensionName, String extensionClassFolder) {
        Objects.requireNonNull(deploymentLocation, "deploymentLocation must not be null");
        Objects.requireNonNull(extensionName, "extensionName must not be null");
        Objects.requireNonNull(extensionClassFolder, "extensionClassFolder must not be null");
        String classesLocation = this.resolveExtensionClassLocation(extensionClassFolder);
        if (new File(classesLocation).exists()) {
            try {
                File file = Files.createTempFile("keycloak", ".jar", new FileAttribute[0]).toFile();
                file.setReadable(true, false);
                file.deleteOnExit();
                ((ZipExporter)((ExplodedImporter)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)extensionName)).as(ExplodedImporter.class)).importDirectory(classesLocation).as(ZipExporter.class)).exportTo(file, true);
                this.withCopyFileToContainer(MountableFile.forHostPath((String)file.getAbsolutePath()), deploymentLocation + "/" + extensionName);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected String resolveExtensionClassLocation(String extensionClassFolder) {
        return Paths.get(MountableFile.forClasspathResource((String)".").getResolvedPath(), new String[0]).getParent().getParent().resolve(extensionClassFolder).toString();
    }

    public SELF withProductionMode() {
        this.startupCommand = KEYCLOAK_START_PRODUCTION_COMMAND;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withRealmImportFile(String importFile) {
        this.importFiles.add(importFile);
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withRealmImportFiles(String ... files) {
        Arrays.stream(files).forEach(this::withRealmImportFile);
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withRamPercentage(int initialRamPercentage, int maxRamPercentage) {
        this.initialRamPercentage = initialRamPercentage;
        this.maxRamPercentage = maxRamPercentage;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withProviderClassesFrom(String ... classesLocations) {
        this.providerClassLocations = Arrays.asList(classesLocations);
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withDefaultProviderClasses() {
        return this.withProviderClassesFrom("target/classes");
    }

    public SELF withProviderLibsFrom(List<File> libs) {
        this.providerLibsLocations = libs;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF useTls() {
        return this.useTlsKeystore("tls.jks", "changeit");
    }

    public SELF useTls(String tlsCertificateFilename, String tlsCertificateKeyFilename) {
        Objects.requireNonNull(tlsCertificateFilename, "tlsCertificateFilename must not be null");
        Objects.requireNonNull(tlsCertificateKeyFilename, "tlsCertificateKeyFilename must not be null");
        this.tlsCertificateFilename = tlsCertificateFilename;
        this.tlsCertificateKeyFilename = tlsCertificateKeyFilename;
        this.useTls = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF useTlsKeystore(String tlsKeystoreFilename, String tlsKeystorePassword) {
        Objects.requireNonNull(tlsKeystoreFilename, "tlsKeystoreFilename must not be null");
        Objects.requireNonNull(tlsKeystorePassword, "tlsKeystorePassword must not be null");
        this.tlsKeystoreFilename = tlsKeystoreFilename;
        this.tlsKeystorePassword = tlsKeystorePassword;
        this.useTls = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF useMutualTls(String tlsTruststoreFilename, String tlsTruststorePassword, HttpsClientAuth httpsClientAuth) {
        Objects.requireNonNull(tlsTruststoreFilename, "tlsTruststoreFilename must not be null");
        Objects.requireNonNull(tlsTruststorePassword, "tlsTruststorePassword must not be null");
        Objects.requireNonNull(httpsClientAuth, "httpsClientAuth must not be null");
        this.tlsTruststoreFilename = tlsTruststoreFilename;
        this.tlsTruststorePassword = tlsTruststorePassword;
        this.httpsClientAuth = httpsClientAuth;
        this.useTls = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withTrustedCertificates(List<String> tlsTrustedCertificateFilenames) {
        Objects.requireNonNull(tlsTrustedCertificateFilenames, "tlsTrustCertificateFilenames must not be null");
        this.tlsTrustedCertificateFilenames = tlsTrustedCertificateFilenames;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withHttpsClientAuth(HttpsClientAuth httpsClientAuth) {
        Objects.requireNonNull(httpsClientAuth, "httpsClientAuth must not be null");
        this.httpsClientAuth = httpsClientAuth;
        this.useTls = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withVerboseOutput() {
        this.useVerbose = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withFeaturesEnabled(String ... features) {
        this.featuresEnabled = features;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withFeaturesDisabled(String ... features) {
        this.featuresDisabled = features;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withDisabledCaching() {
        this.disabledCaching = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withEnabledMetrics() {
        this.metricsEnabled = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withDebug() {
        return this.withDebugFixedPort(0, false);
    }

    public SELF withDebugFixedPort(int hostPort, boolean suspend) {
        return this.withDebug(hostPort, suspend);
    }

    private SELF withDebug(int hostPort, boolean suspend) {
        this.debugEnabled = true;
        this.debugHostPort = hostPort;
        this.debugSuspend = suspend;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withBootstrapAdminDisabled() {
        this.bootstrapAdmin = false;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withOptimizedFlag() {
        this.optimizeFlag = true;
        return ((ExtendableKeycloakContainer)this.self()).withProductionMode();
    }

    public Keycloak getKeycloakAdminClient() {
        if (this.useTls) {
            return Keycloak.getInstance((String)this.getAuthServerUrl(), (String)MASTER_REALM, (String)this.getAdminUsername(), (String)this.getAdminPassword(), (String)ADMIN_CLI_CLIENT, (SSLContext)this.buildSslContext());
        }
        return Keycloak.getInstance((String)this.getAuthServerUrl(), (String)MASTER_REALM, (String)this.getAdminUsername(), (String)this.getAdminPassword(), (String)ADMIN_CLI_CLIENT);
    }

    public void disableLightweightAccessTokenForAdminCliClient(String realm) {
        ClientsResource clients = this.getKeycloakAdminClient().realm(realm).clients();
        ClientRepresentation client = (ClientRepresentation)clients.findByClientId(ADMIN_CLI_CLIENT).get(0);
        Map attributes = client.getAttributes();
        attributes.put("client.use.lightweight.access.token.enabled", "false");
        client.setAttributes(attributes);
        clients.get(client.getId()).update(client);
    }

    private SSLContext buildSslContext() {
        SSLContext sslContext;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            if (this.tlsKeystoreFilename != null) {
                keyStore.load(this.loadResourceAsStream(this.tlsKeystoreFilename), this.tlsKeystorePassword.toCharArray());
            } else if (this.tlsCertificateFilename != null) {
                keyStore.load(null);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(this.loadResourceAsStream(this.tlsCertificateFilename));
                keyStore.setCertificateEntry(certificate.getSubjectX500Principal().getName(), certificate);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
        }
        catch (IOException | GeneralSecurityException e) {
            sslContext = null;
        }
        return sslContext;
    }

    private InputStream loadResourceAsStream(String filename) {
        return ExtendableKeycloakContainer.class.getClassLoader().getResourceAsStream(filename);
    }

    public String getProtocol() {
        return String.format("http%s", this.useTls ? "s" : KEYCLOAK_CONTEXT_PATH);
    }

    public String getAuthServerUrl() {
        return String.format("%s://%s:%s%s", this.getProtocol(), this.getHost(), this.useTls ? this.getHttpsPort() : this.getHttpPort(), this.getContextPath());
    }

    public String getMgmtServerUrl() {
        return String.format("%s://%s:%s%s", this.getProtocol(), this.getHost(), this.getHttpMgmtPort(), this.getContextPath());
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getHttpPort() {
        return this.getMappedPort(8080);
    }

    public int getHttpsPort() {
        return this.getMappedPort(8443);
    }

    public int getHttpMgmtPort() {
        return this.getMappedPort(9000);
    }

    public int getDebugPort() {
        return this.debugEnabled ? this.getMappedPort(8787) : -1;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    public String getKeycloakDefaultVersion() {
        RemoteDockerImage image = this.getImage();
        return this.getDockerImageName().endsWith(":nightly") ? "999.0.0-SNAPSHOT" : KEYCLOAK_VERSION;
    }

    private boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }

    private boolean isNotEmpty(List<String> l) {
        return l != null && !l.isEmpty();
    }
}

