/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.AtlassianDevMetricsReporter;
import com.github.eirslett.maven.plugins.frontend.lib.CorepackRunner;
import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.IncrementalBuildExecutionDigest;
import com.github.eirslett.maven.plugins.frontend.lib.IncrementalMojoHelper;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import java.io.File;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="corepack", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class CorepackMojo
extends AbstractFrontendMojo {
    @Parameter(defaultValue="enable", property="frontend.corepack.arguments", required=false)
    private String arguments;
    @Parameter(defaultValue="true", property="frontend.incremental", required=false)
    private String frontendIncremental;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Parameter(property="triggerFiles", required=false)
    private Set<File> triggerFiles;
    @Parameter(property="excludedFilenames", required=false, defaultValue=".node,node_modules,lcov-report,coverage,screenshots,build,dist,target,.idea,.history,tmp,.settings,.vscode,.git,dependency-reduced-pom.xml,.flattened-pom.xml")
    private Set<String> excludedFilenames;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;
    @Parameter(property="skip.corepack", defaultValue="${skip.corepack}")
    private boolean skip;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public synchronized void execute(FrontendPluginFactory factory) throws Exception {
        CorepackRunner runner = factory.getCorepackRunner();
        IncrementalBuildExecutionDigest.ExecutionCoordinates coordinates = new IncrementalBuildExecutionDigest.ExecutionCoordinates(this.execution.getGoal(), this.execution.getExecutionId(), this.execution.getLifecyclePhase());
        IncrementalMojoHelper incrementalHelper = new IncrementalMojoHelper(this.frontendIncremental, coordinates, this.getTargetDir(), this.workingDirectory, this.triggerFiles, this.excludedFilenames);
        boolean incrementalEnabled = incrementalHelper.incrementalEnabled();
        boolean isIncremental = incrementalEnabled && incrementalHelper.canBeSkipped(this.arguments, runner.getRuntime(), this.environmentVariables, this.project.getArtifactId(), this.getFrontendMavenPluginVersion());
        AtlassianDevMetricsReporter.incrementExecutionCount((String)this.project.getArtifactId(), (String)this.arguments, (AtlassianDevMetricsReporter.Goal)AtlassianDevMetricsReporter.Goal.COREPACK, (String)this.getFrontendMavenPluginVersion(), (boolean)incrementalEnabled, (boolean)isIncremental, () -> {
            if (isIncremental) {
                this.getLog().info((CharSequence)("Skipping corepack execution as no modified files in " + this.workingDirectory));
            } else {
                runner.execute(this.arguments, this.environmentVariables);
                incrementalHelper.acceptIncrementalBuildDigest();
            }
        });
    }
}

