/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import smile.math.DifferentiableMultivariateFunction;
import smile.math.Math;

public abstract class AbstractDifferentiableMultivariateFunction
implements DifferentiableMultivariateFunction {
    private static final double EPS = 1.0E-8;

    @Override
    public double f(double[] x, double[] gradient) {
        double f = this.f(x);
        double[] xh = (double[])x.clone();
        for (int j = 0; j < x.length; ++j) {
            double temp = x[j];
            double h = 1.0E-8 * Math.abs(temp);
            if (h == 0.0) {
                h = 1.0E-8;
            }
            xh[j] = temp + h;
            h = xh[j] - temp;
            double fh = this.f(xh);
            xh[j] = temp;
            gradient[j] = (fh - f) / h;
        }
        return f;
    }
}

