/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import smile.math.Math;

public class Complex {
    private final double re;
    private final double im;

    public Complex(double real, double imag) {
        this.re = real;
        this.im = imag;
    }

    public String toString() {
        if (this.im == 0.0) {
            return String.format("%.4f", this.re);
        }
        if (this.re == 0.0) {
            return String.format("%.4fi", this.im);
        }
        if (this.im < 0.0) {
            return String.format("%.4f - %.4fi", this.re, -this.im);
        }
        return String.format("%.4f + %.4fi", this.re, this.im);
    }

    public boolean equals(Object o) {
        if (o instanceof Complex) {
            Complex c = (Complex)o;
            if (this.re == c.re && this.im == c.im) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.re) ^ Double.doubleToLongBits(this.re) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.im) ^ Double.doubleToLongBits(this.im) >>> 32);
        return hash;
    }

    public double abs() {
        return Math.hypot(this.re, this.im);
    }

    public double phase() {
        return Math.atan2(this.im, this.re);
    }

    public Complex plus(Complex b) {
        Complex a = this;
        double real = a.re + b.re;
        double imag = a.im + b.im;
        return new Complex(real, imag);
    }

    public Complex minus(Complex b) {
        Complex a = this;
        double real = a.re - b.re;
        double imag = a.im - b.im;
        return new Complex(real, imag);
    }

    public Complex times(Complex b) {
        Complex a = this;
        double real = a.re * b.re - a.im * b.im;
        double imag = a.re * b.im + a.im * b.re;
        return new Complex(real, imag);
    }

    public Complex times(double b) {
        return new Complex(b * this.re, b * this.im);
    }

    public Complex div(Complex b) {
        double cdivi;
        double cdivr;
        if (Math.abs(b.re) > Math.abs(b.im)) {
            double r = b.im / b.re;
            double d = b.re + r * b.im;
            cdivr = (this.re + r * this.im) / d;
            cdivi = (this.im - r * this.re) / d;
        } else {
            double r = b.re / b.im;
            double d = b.im + r * b.re;
            cdivr = (r * this.re + this.im) / d;
            cdivi = (r * this.im - this.re) / d;
        }
        return new Complex(cdivr, cdivi);
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public Complex reciprocal() {
        double scale = this.re * this.re + this.im * this.im;
        return new Complex(this.re / scale, -this.im / scale);
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public Complex exp() {
        return new Complex(Math.exp(this.re) * Math.cos(this.im), Math.exp(this.re) * Math.sin(this.im));
    }

    public Complex sin() {
        return new Complex(Math.sin(this.re) * Math.cosh(this.im), Math.cos(this.re) * Math.sinh(this.im));
    }

    public Complex cos() {
        return new Complex(Math.cos(this.re) * Math.cosh(this.im), -Math.sin(this.re) * Math.sinh(this.im));
    }

    public Complex tan() {
        return this.sin().div(this.cos());
    }
}

