/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Math;
import smile.math.kernel.MercerKernel;

public class HellingerKernel
implements MercerKernel<double[]> {
    public String toString() {
        return "Hellinger Kernel";
    }

    @Override
    public double k(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.sqrt(x[i] * y[i]);
        }
        return sum;
    }
}

