/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Scanner;
import smile.math.blas.Transpose;
import smile.math.blas.UPLO;
import smile.math.matrix.FloatMatrix;
import smile.math.matrix.FloatSparseMatrix;
import smile.math.matrix.FloatSymmMatrix;
import smile.math.matrix.IMatrix;
import smile.util.SparseArray;
import smile.util.Strings;

public abstract class SMatrix
extends IMatrix<float[]> {
    public abstract SMatrix set(int var1, int var2, float var3);

    public SMatrix update(int i, int j, float x) {
        return this.set(i, j, x);
    }

    public abstract float get(int var1, int var2);

    public float apply(int i, int j) {
        return this.get(i, j);
    }

    @Override
    String str(int i, int j) {
        return Strings.format(this.get(i, j), true);
    }

    public float[] diag() {
        int n = Math.min(this.nrows(), this.ncols());
        float[] d = new float[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.get(i, i);
        }
        return d;
    }

    public float trace() {
        int n = Math.min(this.nrows(), this.ncols());
        float t2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            t2 += this.get(i, i);
        }
        return t2;
    }

    public abstract void mv(Transpose var1, float var2, float[] var3, float var4, float[] var5);

    @Override
    public float[] mv(float[] x) {
        float[] y = new float[this.nrows()];
        this.mv(Transpose.NO_TRANSPOSE, 1.0f, x, 0.0f, y);
        return y;
    }

    @Override
    public void mv(float[] x, float[] y) {
        this.mv(Transpose.NO_TRANSPOSE, 1.0f, x, 0.0f, y);
    }

    public void mv(float alpha, float[] x, float beta, float[] y) {
        this.mv(Transpose.NO_TRANSPOSE, alpha, x, beta, y);
    }

    @Override
    public float[] tv(float[] x) {
        float[] y = new float[this.ncols()];
        this.mv(Transpose.TRANSPOSE, 1.0f, x, 0.0f, y);
        return y;
    }

    @Override
    public void tv(float[] x, float[] y) {
        this.mv(Transpose.TRANSPOSE, 1.0f, x, 0.0f, y);
    }

    public void tv(float alpha, float[] x, float beta, float[] y) {
        this.mv(Transpose.TRANSPOSE, alpha, x, beta, y);
    }

    public static SMatrix market(Path path) throws IOException, ParseException {
        Throwable throwable = null;
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path));){
            String format;
            Throwable throwable2;
            Scanner scanner;
            block70: {
                int i;
                int nz;
                int ncols;
                int nrows;
                String line;
                boolean skew;
                boolean symmetric;
                block71: {
                    FloatSymmMatrix k2;
                    block72: {
                        block73: {
                            block67: {
                                FloatMatrix j2;
                                block68: {
                                    block69: {
                                        scanner = new Scanner(reader);
                                        throwable2 = null;
                                        String header = scanner.next();
                                        if (!header.equals("%%MatrixMarket")) {
                                            throw new ParseException("Invalid Matrix Market file header", reader.getLineNumber());
                                        }
                                        String object = scanner.next();
                                        if (!object.equals("matrix")) {
                                            throw new UnsupportedOperationException("The object is not a matrix file: " + object);
                                        }
                                        format = scanner.next();
                                        String field = scanner.next();
                                        if (field.equals("complex") || field.equals("pattern")) {
                                            throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                        }
                                        String symmetry = scanner.nextLine().trim();
                                        if (symmetry.equals("Hermitian")) {
                                            throw new UnsupportedOperationException("No support of Hermitian matrix");
                                        }
                                        symmetric = symmetry.equals("symmetric");
                                        skew = symmetry.equals("skew-symmetric");
                                        line = scanner.nextLine();
                                        while (line.startsWith("%")) {
                                            line = scanner.nextLine();
                                        }
                                        if (!format.equals("array")) break block67;
                                        Scanner s = new Scanner(line);
                                        int nrows2 = s.nextInt();
                                        int ncols2 = s.nextInt();
                                        FloatMatrix matrix = new FloatMatrix(nrows2, ncols2);
                                        for (int j2 = 0; j2 < ncols2; ++j2) {
                                            for (int i2 = 0; i2 < nrows2; ++i2) {
                                                float x = scanner.nextFloat();
                                                matrix.set(i2, j2, x);
                                            }
                                        }
                                        if (symmetric) {
                                            matrix.uplo(UPLO.LOWER);
                                        }
                                        j2 = matrix;
                                        if (scanner == null) break block68;
                                        if (throwable2 == null) break block69;
                                        try {
                                            scanner.close();
                                        }
                                        catch (Throwable i2) {
                                            throwable2.addSuppressed(i2);
                                        }
                                        break block68;
                                    }
                                    scanner.close();
                                }
                                return j2;
                            }
                            if (!format.equals("coordinate")) break block70;
                            Scanner s = new Scanner(line);
                            nrows = s.nextInt();
                            ncols = s.nextInt();
                            nz = s.nextInt();
                            if (!symmetric || nz != nrows * (nrows + 1) / 2) break block71;
                            if (nrows != ncols) {
                                throw new IllegalStateException(String.format("Symmetric matrix is not square: %d != %d", nrows, ncols));
                            }
                            FloatSymmMatrix matrix = new FloatSymmMatrix(UPLO.LOWER, nrows);
                            for (int k2 = 0; k2 < nz; ++k2) {
                                String[] tokens = scanner.nextLine().trim().split("\\s+");
                                if (tokens.length != 3) {
                                    throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                                }
                                int i3 = Integer.parseInt(tokens[0]) - 1;
                                int j = Integer.parseInt(tokens[1]) - 1;
                                float x = Float.parseFloat(tokens[2]);
                                matrix.set(i3, j, x);
                            }
                            k2 = matrix;
                            if (scanner == null) break block72;
                            if (throwable2 == null) break block73;
                            try {
                                scanner.close();
                            }
                            catch (Throwable tokens) {
                                throwable2.addSuppressed(tokens);
                            }
                            break block72;
                        }
                        scanner.close();
                    }
                    return k2;
                }
                if (skew && nz == nrows * (nrows + 1) / 2) {
                    if (nrows != ncols) {
                        throw new IllegalStateException(String.format("Skew-symmetric matrix is not square: %d != %d", nrows, ncols));
                    }
                    FloatMatrix matrix = new FloatMatrix(nrows, ncols);
                    for (int k = 0; k < nz; ++k) {
                        String[] tokens = scanner.nextLine().trim().split("\\s+");
                        if (tokens.length != 3) {
                            throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                        }
                        int i4 = Integer.parseInt(tokens[0]) - 1;
                        int j = Integer.parseInt(tokens[1]) - 1;
                        float x = Float.parseFloat(tokens[2]);
                        matrix.set(i4, j, x);
                        matrix.set(j, i4, -x);
                    }
                    FloatMatrix k = matrix;
                    return k;
                }
                int[] colSize = new int[ncols];
                ArrayList<SparseArray> rows = new ArrayList<SparseArray>();
                for (int i5 = 0; i5 < nrows; ++i5) {
                    rows.add(new SparseArray());
                }
                for (int k = 0; k < nz; ++k) {
                    String[] tokens = scanner.nextLine().trim().split("\\s+");
                    if (tokens.length != 3) {
                        throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                    }
                    i = Integer.parseInt(tokens[0]) - 1;
                    int j = Integer.parseInt(tokens[1]) - 1;
                    double x = Double.parseDouble(tokens[2]);
                    SparseArray row = (SparseArray)rows.get(i);
                    row.set(j, x);
                    int n = j;
                    colSize[n] = colSize[n] + 1;
                    if (symmetric) {
                        row = (SparseArray)rows.get(j);
                        row.set(i, x);
                        int n2 = i;
                        colSize[n2] = colSize[n2] + 1;
                        continue;
                    }
                    if (!skew) continue;
                    row = (SparseArray)rows.get(j);
                    row.set(i, -x);
                    int n3 = i;
                    colSize[n3] = colSize[n3] + 1;
                }
                int[] pos = new int[ncols];
                int[] colIndex = new int[ncols + 1];
                for (i = 0; i < ncols; ++i) {
                    colIndex[i + 1] = colIndex[i] + colSize[i];
                }
                if (symmetric || skew) {
                    nz *= 2;
                }
                int[] rowIndex = new int[nz];
                float[] x = new float[nz];
                for (int i6 = 0; i6 < nrows; ++i6) {
                    for (SparseArray.Entry e : (SparseArray)rows.get(i6)) {
                        int j = e.i;
                        int k = colIndex[j] + pos[j];
                        rowIndex[k] = i6;
                        x[k] = (float)e.x;
                        int n = j;
                        pos[n] = pos[n] + 1;
                    }
                }
                FloatSparseMatrix matrix = new FloatSparseMatrix(nrows, ncols, x, rowIndex, colIndex);
                FloatSparseMatrix floatSparseMatrix = matrix;
                return floatSparseMatrix;
            }
            try {
                try {
                    throw new ParseException("Invalid Matrix Market format: " + format, 0);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (scanner != null) {
                    if (throwable2 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable tokens) {
                            throwable2.addSuppressed(tokens);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
    }

    SMatrix square() {
        final SMatrix A = this;
        return new SMatrix(){
            private int m;
            private int n;
            private float[] Ax;
            {
                this.m = Math.max(A.nrows(), A.ncols());
                this.n = Math.min(A.nrows(), A.ncols());
                this.Ax = new float[this.m + this.n];
            }

            @Override
            public int nrows() {
                return this.n;
            }

            @Override
            public int ncols() {
                return this.n;
            }

            @Override
            public long size() {
                return this.m + this.n;
            }

            @Override
            public void mv(float[] work, int inputOffset, int outputOffset) {
                System.arraycopy(work, inputOffset, this.Ax, 0, this.n);
                if (A.nrows() >= A.ncols()) {
                    A.mv(this.Ax, 0, this.n);
                    A.tv(this.Ax, this.n, 0);
                } else {
                    A.tv(this.Ax, 0, this.n);
                    A.mv(this.Ax, this.n, 0);
                }
                System.arraycopy(this.Ax, 0, work, outputOffset, this.n);
            }

            @Override
            public void tv(float[] work, int inputOffset, int outputOffset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void mv(Transpose trans, float alpha, float[] x, float beta, float[] y) {
                throw new UnsupportedOperationException();
            }

            @Override
            public float get(int i, int j) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SMatrix set(int i, int j, float x) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

