/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import smile.math.special.Gamma;

public class ChiSqTest {
    public final String method;
    public final double df;
    public final double chisq;
    public final double pvalue;

    private ChiSqTest(String method, double chisq2, double df, double pvalue) {
        this.method = method;
        this.chisq = chisq2;
        this.df = df;
        this.pvalue = pvalue;
    }

    public String toString() {
        return String.format("%s Chi-squared Test(t = %.4f, df = %.3f, p-value = %G)", this.method, this.chisq, this.df, this.pvalue);
    }

    public static ChiSqTest test(int[] bins, double[] prob) {
        return ChiSqTest.test(bins, prob, 1);
    }

    public static ChiSqTest test(int[] bins, double[] prob, int constraints) {
        int nbins = bins.length;
        int df = nbins - constraints;
        int n = 0;
        for (int i = 0; i < nbins; ++i) {
            n += bins[i];
        }
        double chisq2 = 0.0;
        for (int j = 0; j < nbins; ++j) {
            if (prob[j] < 0.0 || prob[j] > 1.0 || prob[j] == 0.0 && bins[j] > 0) {
                throw new IllegalArgumentException("Bad expected number");
            }
            if (prob[j] == 0.0 && bins[j] == 0) {
                --df;
                continue;
            }
            double nj = (double)n * prob[j];
            double temp = (double)bins[j] - nj;
            chisq2 += temp * temp / nj;
        }
        double p = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq2);
        return new ChiSqTest("One Sample", chisq2, df, p);
    }

    public static ChiSqTest test(int[] bins1, int[] bins2) {
        return ChiSqTest.test(bins1, bins2, 1);
    }

    public static ChiSqTest test(int[] bins1, int[] bins2, int constraints) {
        if (bins1.length != bins2.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        int nbins = bins1.length;
        int df = nbins - constraints;
        double chisq2 = 0.0;
        for (int j = 0; j < nbins; ++j) {
            if (bins1[j] == 0 && bins2[j] == 0) {
                --df;
                continue;
            }
            double temp = bins1[j] - bins2[j];
            chisq2 += temp * temp / (double)(bins1[j] + bins2[j]);
        }
        double p = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq2);
        return new ChiSqTest("Two Sample", chisq2, df, p);
    }

    public static ChiSqTest test(int[][] table) {
        double TINY = 1.0E-16;
        int ni = table.length;
        int nj = table[0].length;
        boolean correct = false;
        if (ni == 2 && nj == 2) {
            correct = true;
        }
        double sum = 0.0;
        int nni = ni;
        double[] sumi = new double[ni];
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                int n = i;
                sumi[n] = sumi[n] + (double)table[i][j];
                sum += (double)table[i][j];
            }
            if (sumi[i] != 0.0) continue;
            --nni;
        }
        int nnj = nj;
        double[] sumj = new double[nj];
        for (int j = 0; j < nj; ++j) {
            for (int i = 0; i < ni; ++i) {
                int n = j;
                sumj[n] = sumj[n] + (double)table[i][j];
            }
            if (sumj[j] != 0.0) continue;
            --nnj;
        }
        int df = nni * nnj - nni - nnj + 1;
        double chisq2 = 0.0;
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                double expctd = sumj[j] * sumi[i] / sum;
                double temp = (double)table[i][j] - expctd;
                if (correct) {
                    temp = Math.abs(temp) - 0.5;
                }
                chisq2 += temp * temp / (expctd + 1.0E-16);
            }
        }
        double prob = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq2);
        int minij = nni < nnj ? nni - 1 : nnj - 1;
        double v = Math.sqrt(chisq2 / (sum * (double)minij));
        return new ChiSqTest("Pearson's", chisq2, df, prob);
    }
}

