/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import smile.math.MathEx;
import smile.math.special.Beta;

public class TTest {
    public final String method;
    public final double df;
    public final double t;
    public final double pvalue;

    private TTest(String method, double t2, double df, double pvalue) {
        this.method = method;
        this.t = t2;
        this.df = df;
        this.pvalue = pvalue;
    }

    public String toString() {
        return String.format("%s t-test(t = %.4f, df = %.3f, p-value = %G)", this.method, this.t, this.df, this.pvalue);
    }

    public static TTest test(double[] x, double mean) {
        int n = x.length;
        double mu = MathEx.mean(x);
        double var = MathEx.var(x);
        int df = n - 1;
        double t2 = (mu - mean) / Math.sqrt(var / (double)n);
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t2 * t2));
        return new TTest("One Sample", t2, df, p);
    }

    public static TTest test(double[] x, double[] y) {
        return TTest.test(x, y, false);
    }

    public static TTest test(double[] x, double[] y, boolean equalVariance) {
        if (equalVariance) {
            int n1 = x.length;
            int n2 = y.length;
            double mu1 = MathEx.mean(x);
            double var1 = MathEx.var(x);
            double mu2 = MathEx.mean(y);
            double var2 = MathEx.var(y);
            int df = n1 + n2 - 2;
            double svar = ((double)(n1 - 1) * var1 + (double)(n2 - 1) * var2) / (double)df;
            double t2 = (mu1 - mu2) / Math.sqrt(svar * (1.0 / (double)n1 + 1.0 / (double)n2));
            double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t2 * t2));
            return new TTest("Equal Variance Two Sample", t2, df, p);
        }
        int n1 = x.length;
        int n2 = y.length;
        double mu1 = MathEx.mean(x);
        double var1 = MathEx.var(x);
        double mu2 = MathEx.mean(y);
        double var2 = MathEx.var(y);
        double df = MathEx.sqr(var1 / (double)n1 + var2 / (double)n2) / (MathEx.sqr(var1 / (double)n1) / (double)(n1 - 1) + MathEx.sqr(var2 / (double)n2) / (double)(n2 - 1));
        double t3 = (mu1 - mu2) / Math.sqrt(var1 / (double)n1 + var2 / (double)n2);
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * df, 0.5, df / (df + t3 * t3));
        return new TTest("Unequal Variance Two Sample", t3, df, p);
    }

    public static TTest testPaired(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        double mu1 = MathEx.mean(x);
        double var1 = MathEx.var(x);
        double mu2 = MathEx.mean(y);
        double var2 = MathEx.var(y);
        int n = x.length;
        int df = n - 1;
        double cov = 0.0;
        for (int j = 0; j < n; ++j) {
            cov += (x[j] - mu1) * (y[j] - mu2);
        }
        double sd = Math.sqrt((var1 + var2 - 2.0 * (cov /= (double)df)) / (double)n);
        double t2 = (mu1 - mu2) / sd;
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t2 * t2));
        return new TTest("Paired", t2, df, p);
    }

    public static TTest test(double r, int df) {
        double TINY = 1.0E-16;
        double t2 = r * Math.sqrt((double)df / ((1.0 - r + 1.0E-16) * (1.0 + r + 1.0E-16)));
        double p = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t2 * t2));
        return new TTest("Pearson correlation coefficient", t2, df, p);
    }
}

