/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.jxl;

import java.util.ArrayList;
import jxl.Cell;
import jxl.Workbook;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class JxlUtils {
    private JxlUtils() {
    }

    public static boolean isEmpty(Cell cell) {
        return cell == null || !StringUtils.hasText((String)cell.getContents());
    }

    public static boolean isEmpty(Cell[] row) {
        if (ObjectUtils.isEmpty((Object[])row)) {
            return true;
        }
        for (Cell cell : row) {
            if (JxlUtils.isEmpty(cell)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSheets(Workbook workbook) {
        return workbook != null && workbook.getNumberOfSheets() > 0;
    }

    public static String[] extractContents(Cell[] row) {
        ArrayList<String> values = new ArrayList<String>();
        if (!ObjectUtils.isEmpty((Object[])row)) {
            for (Cell cell : row) {
                if (!JxlUtils.isEmpty(cell)) {
                    values.add(cell.getColumn(), cell.getContents());
                    continue;
                }
                values.add(cell.getColumn(), "");
            }
        }
        return values.toArray(new String[0]);
    }
}

