/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.mapping;

import java.util.List;
import org.springframework.batch.item.excel.Sheet;
import org.springframework.batch.item.excel.support.rowset.ColumnNameExtractor;
import org.springframework.batch.item.excel.support.rowset.DefaultRowSet;
import org.springframework.batch.item.excel.support.rowset.DefaultRowSetMetaData;
import org.springframework.batch.item.excel.support.rowset.RowSet;
import org.springframework.batch.item.excel.support.rowset.RowSetFactory;
import org.springframework.batch.item.excel.support.rowset.StaticColumnNameExtractor;

public class GenericRowSetFactory
implements RowSetFactory {
    private ColumnNameExtractor columnNameExtractor;

    public GenericRowSetFactory(List<String> column) {
        this.columnNameExtractor = new StaticColumnNameExtractor(column.toArray(new String[0]));
    }

    @Override
    public RowSet create(Sheet sheet) {
        DefaultRowSetMetaData metaData = new DefaultRowSetMetaData(sheet, this.columnNameExtractor);
        return new DefaultRowSet(sheet, metaData);
    }

    public void setColumnNameExtractor(ColumnNameExtractor columnNameExtractor) {
        this.columnNameExtractor = columnNameExtractor;
    }
}

