/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.support.rowset;

import java.util.Properties;
import org.springframework.batch.item.excel.Sheet;
import org.springframework.batch.item.excel.support.rowset.RowSet;
import org.springframework.batch.item.excel.support.rowset.RowSetMetaData;

public class DefaultRowSet
implements RowSet {
    private final Sheet sheet;
    private final RowSetMetaData metaData;
    private int currentRowIndex = -1;
    private String[] currentRow;

    public DefaultRowSet(Sheet sheet, RowSetMetaData metaData) {
        this.sheet = sheet;
        this.metaData = metaData;
    }

    @Override
    public RowSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean next() {
        this.currentRow = null;
        ++this.currentRowIndex;
        if (this.currentRowIndex < this.sheet.getNumberOfRows()) {
            this.currentRow = this.sheet.getRow(this.currentRowIndex);
            return true;
        }
        return false;
    }

    @Override
    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    @Override
    public String[] getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public String getColumnValue(int idx) {
        return this.currentRow[idx];
    }

    @Override
    public Properties getProperties() {
        String[] names = this.metaData.getColumnNames();
        if (names == null) {
            throw new IllegalStateException("Cannot create properties without meta data");
        }
        Properties props = new Properties();
        for (int i = 0; i < this.currentRow.length; ++i) {
            String value = this.currentRow[i];
            if (value == null) continue;
            props.setProperty(names[i], value);
        }
        return props;
    }
}

