/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.components;

import com.github.lgooddatepicker.components.TimePicker;
import com.github.lgooddatepicker.optionalusertools.PickerUtilities;
import com.github.lgooddatepicker.optionalusertools.TimeVetoPolicy;
import com.github.lgooddatepicker.zinternaltools.ExtraTimeStrings;
import com.github.lgooddatepicker.zinternaltools.InternalConstants;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.privatejgoodies.forms.layout.ColumnSpec;
import com.privatejgoodies.forms.layout.ConstantSize;
import com.privatejgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.time.Clock;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class TimePickerSettings {
    private boolean allowEmptyTimes = true;
    private boolean allowKeyboardEditing = true;
    public Border borderTimePopup;
    private Clock clock = Clock.systemDefaultZone();
    private HashMap<TimeArea, Color> colors = new HashMap();
    private boolean displayToggleTimeMenuButton = true;
    private boolean displaySpinnerButtons = false;
    public Font fontInvalidTime;
    public Font fontValidTime;
    public Font fontVetoedTime;
    private DateTimeFormatter formatForDisplayTime;
    private DateTimeFormatter formatForMenuTimes;
    public ArrayList<DateTimeFormatter> formatsForParsing;
    private Integer gapBeforeButtonPixels = null;
    public LocalTime initialTime = null;
    public int maximumVisibleMenuRows = 10;
    private int minimumSpinnerButtonWidthInPixels = 20;
    private int minimumToggleTimeMenuButtonWidthInPixels = 26;
    private TimePicker parent;
    private ArrayList<LocalTime> potentialMenuTimes;
    private Integer sizeTextFieldMinimumWidth = null;
    private boolean sizeTextFieldMinimumWidthDefaultOverride = true;
    private Locale locale;
    public boolean useLowercaseForDisplayTime = true;
    public boolean useLowercaseForMenuTimes = true;
    private TimeVetoPolicy vetoPolicy = null;
    public Integer zDateTimePicker_GapBeforeTimePickerPixels = null;

    public TimePickerSettings() {
        this(Locale.getDefault());
    }

    public TimePickerSettings(Locale timeLocale) {
        for (TimeArea area : TimeArea.values()) {
            this.colors.put(area, area.defaultColor);
        }
        this.locale = timeLocale;
        this.generatePotentialMenuTimes(TimeIncrement.ThirtyMinutes, null, null);
        this.formatForDisplayTime = ExtraTimeStrings.getDefaultFormatForDisplayTime(timeLocale);
        this.formatForMenuTimes = ExtraTimeStrings.getDefaultFormatForMenuTimes(timeLocale);
        FormatStyle[] allFormatStyles = new FormatStyle[]{FormatStyle.SHORT, FormatStyle.MEDIUM, FormatStyle.LONG, FormatStyle.FULL};
        this.formatsForParsing = new ArrayList();
        this.formatsForParsing.add(DateTimeFormatter.ISO_LOCAL_TIME);
        for (FormatStyle formatStyle : allFormatStyles) {
            DateTimeFormatter parseFormat = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendLocalized(null, formatStyle).toFormatter(timeLocale);
            this.formatsForParsing.add(parseFormat);
        }
        ArrayList<DateTimeFormatter> extraFormatters = ExtraTimeStrings.getExtraTimeParsingFormatsForLocale(timeLocale);
        this.formatsForParsing.addAll(extraFormatters);
        this.borderTimePopup = new EmptyBorder(0, 0, 0, 0);
        this.fontValidTime = new JTextField().getFont();
        this.fontInvalidTime = new JTextField().getFont();
        this.fontVetoedTime = new JTextField().getFont();
        HashMap<TextAttribute, Boolean> additionalAttributes = new HashMap<TextAttribute, Boolean>();
        additionalAttributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        this.fontVetoedTime = this.fontVetoedTime.deriveFont(additionalAttributes);
    }

    public void generatePotentialMenuTimes(TimeIncrement timeIncrement, LocalTime optionalStartTime, LocalTime optionalEndTime) {
        LocalTime startTime = optionalStartTime == null ? LocalTime.MIN : optionalStartTime;
        LocalTime endTime = optionalEndTime == null ? LocalTime.MAX : optionalEndTime;
        this.potentialMenuTimes = new ArrayList();
        int increment = timeIncrement.minutes;
        LocalTime entry = LocalTime.MIDNIGHT;
        boolean continueLoop = true;
        while (continueLoop) {
            if (PickerUtilities.isLocalTimeInRange(entry, startTime, endTime, true)) {
                this.potentialMenuTimes.add(entry);
            }
            continueLoop = !LocalTime.MIDNIGHT.equals(entry = entry.plusMinutes(increment));
        }
    }

    public void generatePotentialMenuTimes(ArrayList<LocalTime> desiredTimes) {
        this.potentialMenuTimes = new ArrayList();
        if (desiredTimes == null || desiredTimes.isEmpty()) {
            return;
        }
        TreeSet<LocalTime> timeSet = new TreeSet<LocalTime>();
        for (LocalTime desiredTime : desiredTimes) {
            if (desiredTime == null) continue;
            timeSet.add(desiredTime);
        }
        for (LocalTime timeSetEntry : timeSet) {
            this.potentialMenuTimes.add(timeSetEntry);
        }
    }

    public boolean getAllowEmptyTimes() {
        return this.allowEmptyTimes;
    }

    public boolean getAllowKeyboardEditing() {
        return this.allowKeyboardEditing;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Color getColor(TimeArea area) {
        return this.colors.get((Object)area);
    }

    public boolean getDisplaySpinnerButtons() {
        return this.displaySpinnerButtons;
    }

    public boolean getDisplayToggleTimeMenuButton() {
        return this.displayToggleTimeMenuButton;
    }

    public DateTimeFormatter getFormatForDisplayTime() {
        return this.formatForDisplayTime;
    }

    public DateTimeFormatter getFormatForMenuTimes() {
        return this.formatForMenuTimes;
    }

    public Integer getGapBeforeButtonPixels() {
        return this.gapBeforeButtonPixels;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getMinimumSpinnerButtonWidthInPixels() {
        return this.minimumSpinnerButtonWidthInPixels;
    }

    public int getMinimumToggleTimeMenuButtonWidthInPixels() {
        return this.minimumToggleTimeMenuButtonWidthInPixels;
    }

    public ArrayList<LocalTime> getPotentialMenuTimes() {
        return new ArrayList<LocalTime>(this.potentialMenuTimes);
    }

    public Integer getSizeTextFieldMinimumWidth() {
        return this.sizeTextFieldMinimumWidth;
    }

    public boolean getSizeTextFieldMinimumWidthDefaultOverride() {
        return this.sizeTextFieldMinimumWidthDefaultOverride;
    }

    public TimeVetoPolicy getVetoPolicy() {
        return this.vetoPolicy;
    }

    public boolean isTimeAllowed(LocalTime time) {
        if (time == null) {
            return this.allowEmptyTimes;
        }
        return !InternalUtilities.isTimeVetoed(this.vetoPolicy, time);
    }

    public void setAllowEmptyTimes(boolean allowEmptyTimes) {
        this.allowEmptyTimes = allowEmptyTimes;
        if (this.parent != null) {
            this.zApplyAllowEmptyTimes();
        }
    }

    public void setAllowKeyboardEditing(boolean allowKeyboardEditing) {
        this.allowKeyboardEditing = allowKeyboardEditing;
        if (this.parent != null) {
            this.zApplyAllowKeyboardEditing();
        }
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setColor(TimeArea area, Color color) {
        if (color == null) {
            color = area.defaultColor;
        }
        this.colors.put(area, color);
        if (this.parent != null) {
            if (area == TimeArea.TimePickerTextDisabled) {
                this.zApplyDisabledTextColor();
            } else {
                this.parent.zDrawTextFieldIndicators();
            }
        }
    }

    public void setDisplaySpinnerButtons(boolean displaySpinnerButtons) {
        this.displaySpinnerButtons = displaySpinnerButtons;
        this.zApplyDisplaySpinnerButtons();
    }

    public void setDisplayToggleTimeMenuButton(boolean showToggleTimeMenuButton) {
        this.displayToggleTimeMenuButton = showToggleTimeMenuButton;
        this.zApplyDisplayToggleTimeMenuButton();
    }

    public void setFormatForDisplayTime(DateTimeFormatter formatForDisplayTime) {
        this.formatForDisplayTime = formatForDisplayTime;
        if (this.parent != null) {
            this.parent.setTextFieldToValidStateIfNeeded();
        }
    }

    public void setFormatForDisplayTime(String patternString) {
        DateTimeFormatter formatter = PickerUtilities.createFormatterFromPatternString(patternString, this.locale);
        this.setFormatForDisplayTime(formatter);
    }

    public void setFormatForMenuTimes(DateTimeFormatter formatForMenuTimes) {
        this.formatForMenuTimes = formatForMenuTimes;
        if (this.parent != null) {
            this.parent.setTextFieldToValidStateIfNeeded();
        }
    }

    public void setFormatForMenuTimes(String patternString) {
        DateTimeFormatter formatter = PickerUtilities.createFormatterFromPatternString(patternString, this.locale);
        this.setFormatForMenuTimes(formatter);
    }

    public void setGapBeforeButtonPixels(Integer gapBeforeButtonPixels) {
        this.gapBeforeButtonPixels = gapBeforeButtonPixels;
        if (this.parent != null) {
            this.zApplyGapBeforeButtonPixels();
        }
    }

    public void setInitialTimeToNow() {
        this.initialTime = LocalTime.now(this.clock);
    }

    public void setMinimumSpinnerButtonWidthInPixels(int pixels) {
        this.minimumSpinnerButtonWidthInPixels = pixels;
        this.zApplyMinimumSpinnerButtonWidthInPixels();
    }

    public void setMinimumToggleTimeMenuButtonWidthInPixels(int pixels) {
        this.minimumToggleTimeMenuButtonWidthInPixels = pixels;
        this.zApplyMinimumToggleTimeMenuButtonWidthInPixels();
    }

    void setParentTimePicker(TimePicker parentTimePicker) {
        this.parent = parentTimePicker;
    }

    public void setSizeTextFieldMinimumWidth(Integer minimumWidthInPixels) {
        this.sizeTextFieldMinimumWidth = minimumWidthInPixels;
        if (this.parent != null) {
            this.parent.zSetAppropriateTextFieldMinimumWidth();
        }
    }

    public void setSizeTextFieldMinimumWidthDefaultOverride(boolean defaultShouldOverrideIfNeeded) {
        this.sizeTextFieldMinimumWidthDefaultOverride = defaultShouldOverrideIfNeeded;
        if (this.parent != null) {
            this.parent.zSetAppropriateTextFieldMinimumWidth();
        }
    }

    public boolean setVetoPolicy(TimeVetoPolicy vetoPolicy) {
        if (this.parent == null) {
            throw new RuntimeException("TimePickerSettings.setVetoPolicy(), A veto policy can only be set after constructing the TimePicker.");
        }
        this.vetoPolicy = vetoPolicy;
        return this.isTimeAllowed(this.parent.getTime());
    }

    public void use24HourClockFormat() {
        this.formatForMenuTimes = this.formatForDisplayTime = PickerUtilities.createFormatterFromPatternString("HH:mm", this.locale);
    }

    void yApplyNeededSettingsAtTimePickerConstruction() {
        this.zApplyGapBeforeButtonPixels();
        this.zApplyAllowKeyboardEditing();
        this.zApplyInitialTime();
        this.zApplyAllowEmptyTimes();
        this.zApplyMinimumToggleTimeMenuButtonWidthInPixels();
        this.zApplyMinimumSpinnerButtonWidthInPixels();
        this.zApplyDisplayToggleTimeMenuButton();
        this.zApplyDisplaySpinnerButtons();
        this.zApplyDisabledTextColor();
    }

    private void zApplyAllowEmptyTimes() {
        if (!this.allowEmptyTimes && this.parent.getTime() == null) {
            LocalTime defaultTime = LocalTime.of(7, 0);
            if (InternalUtilities.isTimeVetoed(this.vetoPolicy, defaultTime)) {
                throw new RuntimeException("Exception in TimePickerSettings.zApplyAllowEmptyTimes(), Could not initialize a null time to 7am, because 7am is vetoed by the veto policy. To prevent this exception, always call setAllowEmptyTimes() -before- setting a veto policy.");
            }
            this.parent.setTime(defaultTime);
        }
    }

    private void zApplyAllowKeyboardEditing() {
        this.parent.getComponentTimeTextField().setEditable(this.allowKeyboardEditing);
        Color textFieldBorderColor = this.allowKeyboardEditing ? InternalConstants.colorEditableTextFieldBorder : InternalConstants.colorNotEditableTextFieldBorder;
        this.parent.getComponentTimeTextField().setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, textFieldBorderColor), new EmptyBorder(1, 3, 2, 2)));
    }

    void zApplyDisplaySpinnerButtons() {
        if (this.parent == null) {
            return;
        }
        this.parent.getComponentDecreaseSpinnerButton().setEnabled(this.displaySpinnerButtons);
        this.parent.getComponentDecreaseSpinnerButton().setVisible(this.displaySpinnerButtons);
        this.parent.getComponentIncreaseSpinnerButton().setEnabled(this.displaySpinnerButtons);
        this.parent.getComponentIncreaseSpinnerButton().setVisible(this.displaySpinnerButtons);
    }

    void zApplyDisplayToggleTimeMenuButton() {
        if (this.parent == null) {
            return;
        }
        this.parent.getComponentToggleTimeMenuButton().setEnabled(this.displayToggleTimeMenuButton);
        this.parent.getComponentToggleTimeMenuButton().setVisible(this.displayToggleTimeMenuButton);
    }

    private void zApplyGapBeforeButtonPixels() {
        int gapPixels = this.gapBeforeButtonPixels == null ? 0 : this.gapBeforeButtonPixels;
        ConstantSize gapSizeObject = new ConstantSize(gapPixels, ConstantSize.PIXEL);
        ColumnSpec columnSpec = ColumnSpec.createGap(gapSizeObject);
        FormLayout layout = (FormLayout)this.parent.getLayout();
        layout.setColumnSpec(2, columnSpec);
    }

    private void zApplyInitialTime() {
        if (this.allowEmptyTimes && this.initialTime == null) {
            this.parent.setTime(null);
        }
        if (this.initialTime != null) {
            this.parent.setTime(this.initialTime);
        }
    }

    void zApplyMinimumSpinnerButtonWidthInPixels() {
        if (this.parent == null) {
            return;
        }
        Dimension decreaseButtonPreferredSize = this.parent.getComponentDecreaseSpinnerButton().getPreferredSize();
        Dimension increaseButtonPreferredSize = this.parent.getComponentIncreaseSpinnerButton().getPreferredSize();
        int width = Math.max(decreaseButtonPreferredSize.width, increaseButtonPreferredSize.width);
        int height = Math.max(decreaseButtonPreferredSize.height, increaseButtonPreferredSize.height);
        int minimumWidth = this.minimumSpinnerButtonWidthInPixels;
        width = width < minimumWidth ? minimumWidth : width;
        Dimension newSize = new Dimension(width, height);
        this.parent.getComponentDecreaseSpinnerButton().setPreferredSize(newSize);
        this.parent.getComponentIncreaseSpinnerButton().setPreferredSize(newSize);
    }

    void zApplyMinimumToggleTimeMenuButtonWidthInPixels() {
        if (this.parent == null) {
            return;
        }
        Dimension menuButtonPreferredSize = this.parent.getComponentToggleTimeMenuButton().getPreferredSize();
        int width = menuButtonPreferredSize.width;
        int height = menuButtonPreferredSize.height;
        int minimumWidth = this.minimumToggleTimeMenuButtonWidthInPixels;
        width = width < minimumWidth ? minimumWidth : width;
        Dimension newSize = new Dimension(width, height);
        this.parent.getComponentToggleTimeMenuButton().setPreferredSize(newSize);
    }

    void zApplyDisabledTextColor() {
        this.parent.getComponentTimeTextField().setDisabledTextColor(this.getColor(TimeArea.TimePickerTextDisabled));
    }

    public static enum TimeIncrement {
        FiveMinutes(5),
        TenMinutes(10),
        FifteenMinutes(15),
        TwentyMinutes(20),
        ThirtyMinutes(30),
        OneHour(60);

        public final int minutes;

        private TimeIncrement(int minutes) {
            this.minutes = minutes;
            if (60 % minutes != 0) {
                throw new RuntimeException("TimePickerSettings.TimeIncrement Constructor, All time increments must divide evenly into 60.");
            }
        }
    }

    public static enum TimeArea {
        TimePickerTextValidTime(Color.black),
        TimePickerTextInvalidTime(Color.red),
        TimePickerTextVetoedTime(Color.black),
        TimePickerTextDisabled(new Color(109, 109, 109)),
        TextFieldBackgroundValidTime(Color.white),
        TextFieldBackgroundInvalidTime(Color.white),
        TextFieldBackgroundVetoedTime(Color.white),
        TextFieldBackgroundDisallowedEmptyTime(Color.pink),
        TextFieldBackgroundDisabled(new Color(240, 240, 240));

        public Color defaultColor;

        private TimeArea(Color defaultColor) {
            this.defaultColor = defaultColor;
        }
    }
}

