/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.framework.dag;

import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.measures.graph.framework.dag.Sim_Framework_DAG_Set_abstract;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.impl.SetUtils;

public class Sim_Framework_DAG_Set_Knappe_2004
extends Sim_Framework_DAG_Set_abstract {
    private double k = 0.5;

    public Sim_Framework_DAG_Set_Knappe_2004() {
    }

    public Sim_Framework_DAG_Set_Knappe_2004(double k) {
        if (k < 0.0 || k > 1.0) {
            throw new IllegalArgumentException("k parameter must be in [0;1]");
        }
        this.k = k;
    }

    @Override
    public double compare(Set<URI> ancA, Set<URI> ancB, SMconf conf) {
        Set interSecAncestors = SetUtils.intersection(ancA, ancB);
        double nbAncest_a = ancA.size();
        double nbAncest_b = ancB.size();
        double knappe = this.k * ((double)interSecAncestors.size() / nbAncest_a) + (1.0 - this.k) * ((double)interSecAncestors.size() / nbAncest_b);
        return knappe;
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    @Override
    public Boolean isSymmetric() {
        return this.k == 0.5;
    }
}

